/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.transform;

import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.BpmnFactory;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.BpmnTransformer;
import io.camunda.zeebe.engine.processing.deployment.transform.BpmnValidator;
import io.camunda.zeebe.engine.processing.deployment.transform.DeploymentResourceTransformer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.io.DirectBufferInputStream;

public final class BpmnResourceTransformer
implements DeploymentResourceTransformer {
    private final BpmnTransformer bpmnTransformer = BpmnFactory.createTransformer();
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final Function<DeploymentResource, DirectBuffer> checksumGenerator;
    private final BpmnValidator validator;
    private final ProcessState processState;

    public BpmnResourceTransformer(KeyGenerator keyGenerator, StateWriter stateWriter, Function<DeploymentResource, DirectBuffer> checksumGenerator, ProcessState processState, ExpressionProcessor expressionProcessor) {
        this.keyGenerator = keyGenerator;
        this.stateWriter = stateWriter;
        this.checksumGenerator = checksumGenerator;
        this.processState = processState;
        this.validator = BpmnFactory.createValidator(expressionProcessor);
    }

    @Override
    public Either<Failure, Void> transformResource(DeploymentResource resource, DeploymentRecord deployment) {
        BpmnModelInstance definition = this.readProcessDefinition(resource);
        String validationError = this.validator.validate(definition);
        if (validationError == null) {
            this.bpmnTransformer.transformDefinitions(definition);
            return this.checkForDuplicateBpmnId(definition, resource, deployment).map(ok -> {
                this.transformProcessResource(deployment, resource, definition);
                return null;
            });
        }
        String failureMessage = String.format("'%s': %s", resource.getResourceName(), validationError);
        return Either.left(new Failure(failureMessage));
    }

    private BpmnModelInstance readProcessDefinition(DeploymentResource deploymentResource) {
        DirectBuffer resource = deploymentResource.getResourceBuffer();
        DirectBufferInputStream resourceStream = new DirectBufferInputStream(resource);
        return Bpmn.readModelFromStream(resourceStream);
    }

    private Either<Failure, ?> checkForDuplicateBpmnId(BpmnModelInstance process, DeploymentResource resource, DeploymentRecord record) {
        List bpmnProcessIds = process.getDefinitions().getChildElementsByType(Process.class).stream().map(BaseElement::getId).collect(Collectors.toList());
        return record.getProcessesMetadata().stream().filter(metadata -> bpmnProcessIds.contains(metadata.getBpmnProcessId())).findFirst().map(previousResource -> {
            String failureMessage = String.format("Duplicated process id in resources '%s' and '%s'", previousResource.getResourceName(), resource.getResourceName());
            return Either.left(new Failure(failureMessage));
        }).orElse(Either.right(null));
    }

    private void transformProcessResource(DeploymentRecord deploymentEvent, DeploymentResource deploymentResource, BpmnModelInstance definition) {
        Collection<Process> processes = definition.getDefinitions().getChildElementsByType(Process.class);
        for (Process process : processes) {
            if (!process.isExecutable()) continue;
            String bpmnProcessId = process.getId();
            DeployedProcess lastProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString(bpmnProcessId));
            DirectBuffer lastDigest = this.processState.getLatestVersionDigest(BufferUtil.wrapString(bpmnProcessId));
            DirectBuffer resourceDigest = this.checksumGenerator.apply(deploymentResource);
            ProcessMetadata processMetadata = deploymentEvent.processesMetadata().add();
            processMetadata.setBpmnProcessId(BufferUtil.wrapString(process.getId())).setChecksum(resourceDigest).setResourceName(deploymentResource.getResourceNameBuffer());
            boolean isDuplicate = this.isDuplicateOfLatest(deploymentResource, resourceDigest, lastProcess, lastDigest);
            if (isDuplicate) {
                processMetadata.setVersion(lastProcess.getVersion()).setKey(lastProcess.getKey()).markAsDuplicate();
                continue;
            }
            long key = this.keyGenerator.nextKey();
            processMetadata.setKey(key).setVersion(this.processState.getProcessVersion(bpmnProcessId) + 1);
            this.stateWriter.appendFollowUpEvent(key, ProcessIntent.CREATED, new ProcessRecord().wrap(processMetadata, deploymentResource.getResource()));
        }
    }

    private boolean isDuplicateOfLatest(DeploymentResource deploymentResource, DirectBuffer resourceDigest, DeployedProcess lastProcess, DirectBuffer lastVersionDigest) {
        return lastVersionDigest != null && lastProcess != null && lastVersionDigest.equals(resourceDigest) && lastProcess.getResourceName().equals(deploymentResource.getResourceNameBuffer());
    }
}

