/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.transform;

import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import java.io.StringWriter;
import java.util.ArrayList;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ValidationResult;
import org.camunda.bpm.model.xml.validation.ValidationResultFormatter;

public final class ValidationErrorFormatter
implements ValidationResultFormatter {
    @Override
    public void formatElement(StringWriter writer, ModelElementInstance element) {
        writer.append("- Element: ");
        writer.append(this.createElementIdentifier(element));
        writer.append("\n");
    }

    @Override
    public void formatResult(StringWriter writer, ValidationResult result) {
        writer.append("    - ");
        writer.append(result.getType().toString());
        writer.append(": ");
        writer.append(result.getMessage());
        writer.append("\n");
    }

    private String createElementIdentifier(ModelElementInstance element) {
        ArrayList<ModelElementInstance> identifiableElementChain = new ArrayList<ModelElementInstance>();
        ModelElementInstance current = element;
        do {
            identifiableElementChain.add(0, current);
        } while ((current = current instanceof BaseElement && ((BaseElement)current).getId() != null ? null : current.getParentElement()) != null);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < identifiableElementChain.size(); ++i) {
            ModelElementInstance chainElement = (ModelElementInstance)identifiableElementChain.get(i);
            if (chainElement instanceof BaseElement && ((BaseElement)chainElement).getId() != null) {
                sb.append(((BaseElement)chainElement).getId());
            } else {
                sb.append(chainElement.getElementType().getTypeName());
            }
            if (i >= identifiableElementChain.size() - 1) continue;
            sb.append(" > ");
        }
        return sb.toString();
    }
}

