/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.processing.job.JobAcceptFunction;
import io.camunda.zeebe.engine.processing.job.JobCommandPreconditionChecker;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import java.util.List;

final class DefaultJobCommandPreconditionGuard {
    private final JobState state;
    private final JobAcceptFunction acceptCommand;
    private final JobCommandPreconditionChecker preconditionChecker;

    public DefaultJobCommandPreconditionGuard(String intent, JobState state, JobAcceptFunction acceptCommand) {
        this.state = state;
        this.acceptCommand = acceptCommand;
        this.preconditionChecker = new JobCommandPreconditionChecker(intent, List.of(JobState.State.ACTIVATABLE, JobState.State.ACTIVATED));
    }

    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long jobKey = command.getKey();
        JobState.State jobState = this.state.getState(jobKey);
        this.preconditionChecker.check(jobState, jobKey).ifRightOrLeft(ok -> this.acceptCommand.accept(command, commandControl), violation -> commandControl.reject((RejectionType)((Object)((Object)violation.getLeft())), (String)violation.getRight()));
        return true;
    }
}

