/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.engine.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.processing.scheduled.DueDateChecker;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import java.time.Duration;

public final class JobBackoffChecker
implements StreamProcessorLifecycleAware {
    static final long BACKOFF_RESOLUTION = Duration.ofMillis(100L).toMillis();
    private final DueDateChecker backOffDueDateChecker = new DueDateChecker(BACKOFF_RESOLUTION, false, taskResultBuilder -> jobState.findBackedOffJobs(ActorClock.currentTimeMillis(), (key, record) -> taskResultBuilder.appendCommandRecord((long)key, JobIntent.RECUR_AFTER_BACKOFF, (UnifiedRecordValue)record)));

    public JobBackoffChecker(JobState jobState) {
    }

    public void scheduleBackOff(long dueDate) {
        this.backOffDueDateChecker.schedule(dueDate);
    }

    @Override
    public void onRecovered(ReadonlyStreamProcessorContext context) {
        this.backOffDueDateChecker.onRecovered(context);
    }

    @Override
    public void onClose() {
        this.backOffDueDateChecker.onClose();
    }

    @Override
    public void onFailed() {
        this.backOffDueDateChecker.onFailed();
    }

    @Override
    public void onPaused() {
        this.backOffDueDateChecker.onPaused();
    }

    @Override
    public void onResumed() {
        this.backOffDueDateChecker.onResumed();
    }
}

