/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.job.DefaultJobCommandPreconditionGuard;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.analyzers.CatchEventAnalyzer;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.EventScopeInstanceState;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.StringUtil;
import java.util.Optional;
import org.agrona.DirectBuffer;

public class JobThrowErrorProcessor
implements CommandProcessor<JobRecord> {
    public static final String NO_CATCH_EVENT_FOUND = "NO_CATCH_EVENT_FOUND";
    private final IncidentRecord incidentEvent = new IncidentRecord();
    private Either<Failure, CatchEventAnalyzer.CatchEventTuple> foundCatchEvent;
    private final JobState jobState;
    private final ElementInstanceState elementInstanceState;
    private final DefaultJobCommandPreconditionGuard defaultProcessor;
    private final CatchEventAnalyzer stateAnalyzer;
    private final KeyGenerator keyGenerator;
    private final EventScopeInstanceState eventScopeInstanceState;
    private final BpmnEventPublicationBehavior eventPublicationBehavior;
    private final JobMetrics jobMetrics;

    public JobThrowErrorProcessor(ProcessingState state, BpmnEventPublicationBehavior eventPublicationBehavior, KeyGenerator keyGenerator, JobMetrics jobMetrics) {
        this.keyGenerator = keyGenerator;
        this.jobState = state.getJobState();
        this.elementInstanceState = state.getElementInstanceState();
        this.eventScopeInstanceState = state.getEventScopeInstanceState();
        this.defaultProcessor = new DefaultJobCommandPreconditionGuard("throw an error for", this.jobState, this::acceptCommand);
        this.stateAnalyzer = new CatchEventAnalyzer(state.getProcessState(), this.elementInstanceState);
        this.eventPublicationBehavior = eventPublicationBehavior;
        this.jobMetrics = jobMetrics;
    }

    @Override
    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        return this.defaultProcessor.onCommand(command, commandControl);
    }

    @Override
    public void afterAccept(TypedCommandWriter commandWriter, StateWriter stateWriter, long jobKey, Intent intent, JobRecord job) {
        this.jobMetrics.jobErrorThrown(job.getType());
        String serviceTaskInstanceKey = job.getElementId();
        if (NO_CATCH_EVENT_FOUND.equals(serviceTaskInstanceKey)) {
            this.raiseIncident(jobKey, job, stateWriter, this.foundCatchEvent.getLeft());
            return;
        }
        this.eventPublicationBehavior.throwErrorEvent(this.foundCatchEvent.get());
    }

    private void acceptCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long jobKey = command.getKey();
        JobRecord job = this.jobState.getJob(jobKey);
        job.setErrorCode(((JobRecord)command.getValue()).getErrorCodeBuffer());
        job.setErrorMessage(StringUtil.limitString(((JobRecord)command.getValue()).getErrorMessage(), 10000));
        long serviceTaskInstanceKey = job.getElementInstanceKey();
        ElementInstance serviceTaskInstance = this.elementInstanceState.getInstance(serviceTaskInstanceKey);
        DirectBuffer errorCode = job.getErrorCodeBuffer();
        Either<Failure, CatchEventAnalyzer.CatchEventTuple> foundCatchEvent = this.stateAnalyzer.findCatchEvent(errorCode, serviceTaskInstance, Optional.of(job.getErrorMessageBuffer()));
        this.foundCatchEvent = foundCatchEvent;
        if (foundCatchEvent.isLeft()) {
            job.setElementId(NO_CATCH_EVENT_FOUND);
            commandControl.accept(JobIntent.ERROR_THROWN, job);
        } else if (!this.serviceTaskInstanceIsActive(serviceTaskInstance)) {
            commandControl.reject(RejectionType.INVALID_STATE, "Expected to find active service task, but was " + serviceTaskInstance);
        } else if (!this.eventScopeInstanceState.canTriggerEvent(foundCatchEvent.get().getElementInstance().getKey(), foundCatchEvent.get().getCatchEvent().getId())) {
            commandControl.reject(RejectionType.INVALID_STATE, "Expected to find event scope that is accepting events, but was " + foundCatchEvent.get().getElementInstance());
        } else {
            commandControl.accept(JobIntent.ERROR_THROWN, job);
        }
    }

    private boolean serviceTaskInstanceIsActive(ElementInstance serviceTaskInstance) {
        return serviceTaskInstance != null && serviceTaskInstance.isActive();
    }

    private void raiseIncident(long key, JobRecord job, StateWriter stateWriter, Failure failure) {
        this.incidentEvent.reset();
        this.incidentEvent.setErrorType(ErrorType.UNHANDLED_ERROR_EVENT).setErrorMessage(failure.getMessage()).setBpmnProcessId(job.getBpmnProcessIdBuffer()).setProcessDefinitionKey(job.getProcessDefinitionKey()).setProcessInstanceKey(job.getProcessInstanceKey()).setElementId(job.getElementIdBuffer()).setElementInstanceKey(job.getElementInstanceKey()).setJobKey(key).setVariableScopeKey(job.getElementInstanceKey());
        stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), IncidentIntent.CREATED, this.incidentEvent);
    }
}

