/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.message.MessageExpireProcessor;
import io.camunda.zeebe.engine.processing.message.MessageObserver;
import io.camunda.zeebe.engine.processing.message.MessagePublishProcessor;
import io.camunda.zeebe.engine.processing.message.MessageSubscriptionCorrelateProcessor;
import io.camunda.zeebe.engine.processing.message.MessageSubscriptionCreateProcessor;
import io.camunda.zeebe.engine.processing.message.MessageSubscriptionDeleteProcessor;
import io.camunda.zeebe.engine.processing.message.MessageSubscriptionRejectProcessor;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.ScheduledTaskState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.util.FeatureFlags;
import java.util.function.Supplier;

public final class MessageEventProcessors {
    public static void addMessageProcessors(BpmnBehaviors bpmnBehaviors, TypedRecordProcessors typedRecordProcessors, MutableProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskStateFactory, SubscriptionCommandSender subscriptionCommandSender, Writers writers, EngineConfiguration config, FeatureFlags featureFlags) {
        MutableMessageState messageState = processingState.getMessageState();
        MutableMessageSubscriptionState subscriptionState = processingState.getMessageSubscriptionState();
        MutableMessageStartEventSubscriptionState startEventSubscriptionState = processingState.getMessageStartEventSubscriptionState();
        MutableEventScopeInstanceState eventScopeInstanceState = processingState.getEventScopeInstanceState();
        KeyGenerator keyGenerator = processingState.getKeyGenerator();
        MutableProcessState processState = processingState.getProcessState();
        typedRecordProcessors.onCommand(ValueType.MESSAGE, (Intent)MessageIntent.PUBLISH, new MessagePublishProcessor(processingState.getPartitionId(), messageState, subscriptionState, startEventSubscriptionState, eventScopeInstanceState, subscriptionCommandSender, keyGenerator, writers, processState, bpmnBehaviors.eventTriggerBehavior(), bpmnBehaviors.stateBehavior())).onCommand(ValueType.MESSAGE, (Intent)MessageIntent.EXPIRE, new MessageExpireProcessor(writers.state())).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CREATE, new MessageSubscriptionCreateProcessor(processingState.getPartitionId(), messageState, subscriptionState, subscriptionCommandSender, writers, keyGenerator)).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CORRELATE, new MessageSubscriptionCorrelateProcessor(processingState.getPartitionId(), messageState, subscriptionState, subscriptionCommandSender, writers)).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.DELETE, new MessageSubscriptionDeleteProcessor(subscriptionState, subscriptionCommandSender, writers)).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.REJECT, new MessageSubscriptionRejectProcessor(messageState, subscriptionState, subscriptionCommandSender, writers)).withListener(new MessageObserver(scheduledTaskStateFactory, processingState.getPendingMessageSubscriptionState(), subscriptionCommandSender, config.getMessagesTtlCheckerInterval(), config.getMessagesTtlCheckerBatchLimit(), featureFlags.enableMessageTTLCheckerAsync()));
    }
}

