/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceBatchRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceBatchIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;

public final class TerminateProcessInstanceBatchProcessor
implements TypedRecordProcessor<ProcessInstanceBatchRecord> {
    private final TypedCommandWriter commandWriter;
    private final KeyGenerator keyGenerator;
    private final ElementInstanceState elementInstanceState;

    public TerminateProcessInstanceBatchProcessor(Writers writers, KeyGenerator keyGenerator, ElementInstanceState elementInstanceState) {
        this.commandWriter = writers.command();
        this.keyGenerator = keyGenerator;
        this.elementInstanceState = elementInstanceState;
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceBatchRecord> record) {
        ProcessInstanceBatchRecord recordValue = (ProcessInstanceBatchRecord)record.getValue();
        this.elementInstanceState.forEachChild(recordValue.getBatchElementInstanceKey(), recordValue.getIndex(), (childKey, childInstance) -> {
            if (this.canWriteCommand(record, (ElementInstance)childInstance)) {
                this.terminateChildInstance((ElementInstance)childInstance);
                return true;
            }
            ProcessInstanceBatchRecord nextBatchRecord = new ProcessInstanceBatchRecord().setProcessInstanceKey(recordValue.getProcessInstanceKey()).setBatchElementInstanceKey(recordValue.getBatchElementInstanceKey()).setIndex((long)childKey);
            long key = this.keyGenerator.nextKey();
            this.commandWriter.appendFollowUpCommand(key, ProcessInstanceBatchIntent.TERMINATE, nextBatchRecord);
            return false;
        });
    }

    private boolean canWriteCommand(TypedRecord<ProcessInstanceBatchRecord> record, ElementInstance childInstance) {
        int expectedCommandLength = childInstance.getValue().getLength() + record.getLength() + 8192;
        return this.commandWriter.canWriteCommandOfLength(expectedCommandLength);
    }

    private void terminateChildInstance(ElementInstance childInstance) {
        if (childInstance.canTerminate()) {
            this.commandWriter.appendFollowUpCommand(childInstance.getKey(), ProcessInstanceIntent.TERMINATE_ELEMENT, childInstance.getValue());
        }
    }
}

