/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable;

import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.engine.state.variable.DocumentEntry;
import io.camunda.zeebe.engine.state.variable.DocumentEntryIterator;
import io.camunda.zeebe.engine.state.variable.IndexedDocument;
import io.camunda.zeebe.engine.state.variable.VariableInstance;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableRecord;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import org.agrona.DirectBuffer;

public final class VariableBehavior {
    private final VariableState variableState;
    private final StateWriter stateWriter;
    private final KeyGenerator keyGenerator;
    private final IndexedDocument indexedDocument = new IndexedDocument();
    private final VariableRecord variableRecord = new VariableRecord();

    public VariableBehavior(VariableState variableState, StateWriter stateWriter, KeyGenerator keyGenerator) {
        this.variableState = variableState;
        this.stateWriter = stateWriter;
        this.keyGenerator = keyGenerator;
    }

    public void mergeLocalDocument(long scopeKey, long processDefinitionKey, long processInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer document) {
        this.indexedDocument.index(document);
        if (this.indexedDocument.isEmpty()) {
            return;
        }
        this.variableRecord.setScopeKey(scopeKey).setProcessDefinitionKey(processDefinitionKey).setProcessInstanceKey(processInstanceKey).setBpmnProcessId(bpmnProcessId);
        for (DocumentEntry entry : this.indexedDocument) {
            this.applyEntryToRecord(entry);
            this.setLocalVariable(this.variableRecord);
        }
    }

    public void mergeDocument(long scopeKey, long processDefinitionKey, long processInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer document) {
        long parentScope;
        this.indexedDocument.index(document);
        if (this.indexedDocument.isEmpty()) {
            return;
        }
        long currentScope = scopeKey;
        this.variableRecord.setProcessDefinitionKey(processDefinitionKey).setProcessInstanceKey(processInstanceKey).setBpmnProcessId(bpmnProcessId);
        while ((parentScope = this.variableState.getParentScopeKey(currentScope)) > 0L) {
            DocumentEntryIterator entryIterator = this.indexedDocument.iterator();
            this.variableRecord.setScopeKey(currentScope);
            while (entryIterator.hasNext()) {
                DocumentEntry entry = (DocumentEntry)entryIterator.next();
                VariableInstance variableInstance = this.variableState.getVariableInstanceLocal(currentScope, entry.getName());
                if (variableInstance == null || variableInstance.getValue().equals(entry.getValue())) continue;
                this.applyEntryToRecord(entry);
                this.stateWriter.appendFollowUpEvent(variableInstance.getKey(), VariableIntent.UPDATED, this.variableRecord);
                entryIterator.remove();
            }
            currentScope = parentScope;
        }
        this.variableRecord.setScopeKey(currentScope);
        for (DocumentEntry entry : this.indexedDocument) {
            this.applyEntryToRecord(entry);
            this.setLocalVariable(this.variableRecord);
        }
    }

    public void setLocalVariable(long scopeKey, long processDefinitionKey, long processInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer name, DirectBuffer value, int valueOffset, int valueLength) {
        this.variableRecord.setScopeKey(scopeKey).setProcessDefinitionKey(processDefinitionKey).setProcessInstanceKey(processInstanceKey).setBpmnProcessId(bpmnProcessId).setName(name).setValue(value, valueOffset, valueLength);
        this.setLocalVariable(this.variableRecord);
    }

    private void setLocalVariable(VariableRecord record) {
        VariableInstance variableInstance = this.variableState.getVariableInstanceLocal(record.getScopeKey(), record.getNameBuffer());
        if (variableInstance == null) {
            long key = this.keyGenerator.nextKey();
            this.stateWriter.appendFollowUpEvent(key, VariableIntent.CREATED, record);
        } else if (!variableInstance.getValue().equals(record.getValueBuffer())) {
            this.stateWriter.appendFollowUpEvent(variableInstance.getKey(), VariableIntent.UPDATED, record);
        }
    }

    private void applyEntryToRecord(DocumentEntry entry) {
        this.variableRecord.setName(entry.getName()).setValue(entry.getValue());
    }
}

