/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state;

import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.deployment.DbDecisionState;
import io.camunda.zeebe.engine.state.deployment.DbDeploymentState;
import io.camunda.zeebe.engine.state.deployment.DbProcessState;
import io.camunda.zeebe.engine.state.instance.DbElementInstanceState;
import io.camunda.zeebe.engine.state.instance.DbEventScopeInstanceState;
import io.camunda.zeebe.engine.state.instance.DbIncidentState;
import io.camunda.zeebe.engine.state.instance.DbJobState;
import io.camunda.zeebe.engine.state.instance.DbTimerInstanceState;
import io.camunda.zeebe.engine.state.message.DbMessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.message.DbMessageState;
import io.camunda.zeebe.engine.state.message.DbMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.DbProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.migration.DbMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutableBannedInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableDecisionState;
import io.camunda.zeebe.engine.state.mutable.MutableDeploymentState;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableIncidentState;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutablePendingMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutablePendingProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.mutable.MutableTimerInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableVariableState;
import io.camunda.zeebe.engine.state.processing.DbBannedInstanceState;
import io.camunda.zeebe.engine.state.variable.DbVariableState;
import java.util.function.BiConsumer;

public class ProcessingDbState
implements MutableProcessingState {
    private final ZeebeDb<ZbColumnFamilies> zeebeDb;
    private final KeyGenerator keyGenerator;
    private final MutableProcessState processState;
    private final MutableTimerInstanceState timerInstanceState;
    private final MutableElementInstanceState elementInstanceState;
    private final MutableEventScopeInstanceState eventScopeInstanceState;
    private final MutableVariableState variableState;
    private final MutableDeploymentState deploymentState;
    private final MutableJobState jobState;
    private final MutableMessageState messageState;
    private final DbMessageSubscriptionState messageSubscriptionState;
    private final MutableMessageStartEventSubscriptionState messageStartEventSubscriptionState;
    private final DbProcessMessageSubscriptionState processMessageSubscriptionState;
    private final MutableIncidentState incidentState;
    private final MutableBannedInstanceState bannedInstanceState;
    private final MutableMigrationState mutableMigrationState;
    private final MutableDecisionState decisionState;
    private final int partitionId;

    public ProcessingDbState(int partitionId, ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, KeyGenerator keyGenerator, EngineConfiguration config) {
        this.partitionId = partitionId;
        this.zeebeDb = zeebeDb;
        this.keyGenerator = keyGenerator;
        this.variableState = new DbVariableState(zeebeDb, transactionContext);
        this.processState = new DbProcessState(zeebeDb, transactionContext);
        this.timerInstanceState = new DbTimerInstanceState(zeebeDb, transactionContext);
        this.elementInstanceState = new DbElementInstanceState(zeebeDb, transactionContext, this.variableState);
        this.eventScopeInstanceState = new DbEventScopeInstanceState(zeebeDb, transactionContext);
        this.deploymentState = new DbDeploymentState(zeebeDb, transactionContext);
        this.jobState = new DbJobState(zeebeDb, transactionContext, partitionId);
        this.messageState = new DbMessageState(zeebeDb, transactionContext, partitionId);
        this.messageSubscriptionState = new DbMessageSubscriptionState(zeebeDb, transactionContext);
        this.messageStartEventSubscriptionState = new DbMessageStartEventSubscriptionState(zeebeDb, transactionContext);
        this.processMessageSubscriptionState = new DbProcessMessageSubscriptionState(zeebeDb, transactionContext);
        this.incidentState = new DbIncidentState(zeebeDb, transactionContext, partitionId);
        this.bannedInstanceState = new DbBannedInstanceState(zeebeDb, transactionContext, partitionId);
        this.decisionState = new DbDecisionState(zeebeDb, transactionContext, config);
        this.mutableMigrationState = new DbMigrationState(zeebeDb, transactionContext);
    }

    @Override
    public void onRecovered(ReadonlyStreamProcessorContext context) {
        this.messageSubscriptionState.onRecovered(context);
        this.processMessageSubscriptionState.onRecovered(context);
        this.bannedInstanceState.onRecovered(context);
        this.messageState.onRecovered(context);
    }

    @Override
    public MutableDeploymentState getDeploymentState() {
        return this.deploymentState;
    }

    @Override
    public MutableProcessState getProcessState() {
        return this.processState;
    }

    @Override
    public MutableJobState getJobState() {
        return this.jobState;
    }

    @Override
    public MutableMessageState getMessageState() {
        return this.messageState;
    }

    @Override
    public MutableMessageSubscriptionState getMessageSubscriptionState() {
        return this.messageSubscriptionState;
    }

    @Override
    public MutableMessageStartEventSubscriptionState getMessageStartEventSubscriptionState() {
        return this.messageStartEventSubscriptionState;
    }

    @Override
    public MutableProcessMessageSubscriptionState getProcessMessageSubscriptionState() {
        return this.processMessageSubscriptionState;
    }

    @Override
    public MutableIncidentState getIncidentState() {
        return this.incidentState;
    }

    @Override
    public MutableBannedInstanceState getBannedInstanceState() {
        return this.bannedInstanceState;
    }

    @Override
    public MutableVariableState getVariableState() {
        return this.variableState;
    }

    @Override
    public MutableTimerInstanceState getTimerState() {
        return this.timerInstanceState;
    }

    @Override
    public MutableElementInstanceState getElementInstanceState() {
        return this.elementInstanceState;
    }

    @Override
    public MutableEventScopeInstanceState getEventScopeInstanceState() {
        return this.eventScopeInstanceState;
    }

    @Override
    public MutableDecisionState getDecisionState() {
        return this.decisionState;
    }

    @Override
    public MutableMigrationState getMigrationState() {
        return this.mutableMigrationState;
    }

    @Override
    public MutablePendingMessageSubscriptionState getPendingMessageSubscriptionState() {
        return this.messageSubscriptionState;
    }

    @Override
    public MutablePendingProcessMessageSubscriptionState getPendingProcessMessageSubscriptionState() {
        return this.processMessageSubscriptionState;
    }

    @Override
    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public boolean isEmpty(ZbColumnFamilies column) {
        TransactionContext newContext = this.zeebeDb.createContext();
        return this.zeebeDb.isEmpty(column, newContext);
    }

    public <KeyType extends DbKey, ValueType extends DbValue> void forEach(ZbColumnFamilies columnFamily, KeyType keyInstance, ValueType valueInstance, BiConsumer<KeyType, ValueType> visitor) {
        TransactionContext newContext = this.zeebeDb.createContext();
        this.zeebeDb.createColumnFamily(columnFamily, newContext, keyInstance, valueInstance).forEach(visitor);
    }
}

