/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.analyzers;

import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

public final class CatchEventAnalyzer {
    private final CatchEventTuple catchEventTuple = new CatchEventTuple();
    private final ProcessState processState;
    private final ElementInstanceState elementInstanceState;

    public CatchEventAnalyzer(ProcessState processState, ElementInstanceState elementInstanceState) {
        this.processState = processState;
        this.elementInstanceState = elementInstanceState;
    }

    public Either<Failure, CatchEventTuple> findCatchEvent(DirectBuffer errorCode, ElementInstance instance, Optional<DirectBuffer> jobErrorMessage) {
        ArrayList availableCatchEvents = new ArrayList();
        while (instance != null && instance.isActive()) {
            ProcessInstanceRecord instanceRecord = instance.getValue();
            ExecutableProcess process = this.getProcess(instanceRecord.getProcessDefinitionKey());
            Either<List<DirectBuffer>, CatchEventTuple> found = this.findCatchEventInProcess(errorCode, process, instance);
            if (found.isRight()) {
                return Either.right(found.get());
            }
            availableCatchEvents.addAll(found.getLeft());
            long parentElementInstanceKey = instanceRecord.getParentElementInstanceKey();
            instance = this.elementInstanceState.getInstance(parentElementInstanceKey);
        }
        String incidentErrorMessage = String.format("Expected to throw an error event with the code '%s'%s, but it was not caught.%s", BufferUtil.bufferAsString(errorCode), jobErrorMessage.isPresent() && jobErrorMessage.get().capacity() > 0 ? String.format(" with message '%s'", BufferUtil.bufferAsString(jobErrorMessage.get())) : "", availableCatchEvents.isEmpty() ? " No error events are available in the scope." : String.format(" Available error events are [%s]", availableCatchEvents.stream().map(BufferUtil::bufferAsString).collect(Collectors.joining(", "))));
        return Either.left(new Failure(incidentErrorMessage, ErrorType.UNHANDLED_ERROR_EVENT));
    }

    private Either<List<DirectBuffer>, CatchEventTuple> findCatchEventInProcess(DirectBuffer errorCode, ExecutableProcess process, ElementInstance instance) {
        Either<List<DirectBuffer>, CatchEventTuple> availableCatchEvents = Either.left(new ArrayList());
        while (instance != null && instance.isActive() && !instance.isInterrupted()) {
            Either<List<DirectBuffer>, CatchEventTuple> found = this.findCatchEventInScope(errorCode, process, instance);
            if (found.isRight()) {
                return found;
            }
            availableCatchEvents.getLeft().addAll((Collection<DirectBuffer>)found.getLeft());
            long instanceParentKey = instance.getParentKey();
            instance = this.elementInstanceState.getInstance(instanceParentKey);
        }
        return availableCatchEvents;
    }

    private Either<List<DirectBuffer>, CatchEventTuple> findCatchEventInScope(DirectBuffer errorCode, ExecutableProcess process, ElementInstance instance) {
        Either<List<DirectBuffer>, CatchEventTuple> availableCatchEvents = Either.left(new ArrayList());
        ProcessInstanceRecord processInstanceRecord = instance.getValue();
        DirectBuffer elementId = processInstanceRecord.getElementIdBuffer();
        BpmnElementType elementType = processInstanceRecord.getBpmnElementType();
        ExecutableActivity element = process.getElementById(elementId, elementType, ExecutableActivity.class);
        for (ExecutableCatchEvent catchEvent : element.getEvents()) {
            if (!catchEvent.isError()) continue;
            availableCatchEvents.getLeft().add(catchEvent.getError().getErrorCode());
            if (!catchEvent.getError().getErrorCode().equals(errorCode)) continue;
            this.catchEventTuple.instance = instance;
            this.catchEventTuple.catchEvent = catchEvent;
            return Either.right(this.catchEventTuple);
        }
        return availableCatchEvents;
    }

    private ExecutableProcess getProcess(long processDefinitionKey) {
        DeployedProcess deployedProcess = this.processState.getProcessByKey(processDefinitionKey);
        if (deployedProcess == null) {
            throw new IllegalStateException(String.format("Expected process with key '%d' to be deployed but not found", processDefinitionKey));
        }
        return deployedProcess.getProcess();
    }

    public static final class CatchEventTuple {
        private ExecutableCatchEvent catchEvent;
        private ElementInstance instance;

        public ExecutableCatchEvent getCatchEvent() {
            return this.catchEvent;
        }

        public ElementInstance getElementInstance() {
            return this.instance;
        }
    }
}

