/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.dmn.DecisionEngine;
import io.camunda.zeebe.dmn.DecisionEngineFactory;
import io.camunda.zeebe.dmn.ParsedDecisionRequirementsGraph;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.deployment.DeployedDrg;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.deployment.PersistedDecisionRequirements;
import io.camunda.zeebe.engine.state.mutable.MutableDecisionState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.agrona.DirectBuffer;

public final class DbDecisionState
implements MutableDecisionState {
    private final DecisionEngine decisionEngine = DecisionEngineFactory.createDecisionEngine();
    private final DbLong dbDecisionKey = new DbLong();
    private final DbForeignKey<DbLong> fkDecision = new DbForeignKey<DbLong>(this.dbDecisionKey, ZbColumnFamilies.DMN_DECISIONS);
    private final PersistedDecision dbPersistedDecision = new PersistedDecision();
    private final DbString dbDecisionId;
    private final DbLong dbDecisionRequirementsKey;
    private final DbForeignKey<DbLong> fkDecisionRequirements;
    private final PersistedDecisionRequirements dbPersistedDecisionRequirements;
    private final DbString dbDecisionRequirementsId;
    private final DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>> dbDecisionRequirementsKeyAndDecisionKey;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>>, DbNil> decisionKeyByDecisionRequirementsKey;
    private final ColumnFamily<DbLong, PersistedDecision> decisionsByKey;
    private final ColumnFamily<DbString, DbForeignKey<DbLong>> latestDecisionKeysByDecisionId;
    private final ColumnFamily<DbLong, PersistedDecisionRequirements> decisionRequirementsByKey;
    private final ColumnFamily<DbString, DbForeignKey<DbLong>> latestDecisionRequirementsKeysById;
    private final LoadingCache<Long, DeployedDrg> drgCache;

    public DbDecisionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, EngineConfiguration config) {
        this.decisionsByKey = zeebeDb.createColumnFamily(ZbColumnFamilies.DMN_DECISIONS, transactionContext, this.dbDecisionKey, this.dbPersistedDecision);
        this.dbDecisionId = new DbString();
        this.latestDecisionKeysByDecisionId = zeebeDb.createColumnFamily(ZbColumnFamilies.DMN_LATEST_DECISION_BY_ID, transactionContext, this.dbDecisionId, this.fkDecision);
        this.dbDecisionRequirementsKey = new DbLong();
        this.fkDecisionRequirements = new DbForeignKey<DbLong>(this.dbDecisionRequirementsKey, ZbColumnFamilies.DMN_DECISION_REQUIREMENTS);
        this.dbPersistedDecisionRequirements = new PersistedDecisionRequirements();
        this.decisionRequirementsByKey = zeebeDb.createColumnFamily(ZbColumnFamilies.DMN_DECISION_REQUIREMENTS, transactionContext, this.dbDecisionRequirementsKey, this.dbPersistedDecisionRequirements);
        this.dbDecisionRequirementsId = new DbString();
        this.latestDecisionRequirementsKeysById = zeebeDb.createColumnFamily(ZbColumnFamilies.DMN_LATEST_DECISION_REQUIREMENTS_BY_ID, transactionContext, this.dbDecisionRequirementsId, this.fkDecisionRequirements);
        this.dbDecisionRequirementsKeyAndDecisionKey = new DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>>(this.fkDecisionRequirements, this.fkDecision);
        this.decisionKeyByDecisionRequirementsKey = zeebeDb.createColumnFamily(ZbColumnFamilies.DMN_DECISION_KEY_BY_DECISION_REQUIREMENTS_KEY, transactionContext, this.dbDecisionRequirementsKeyAndDecisionKey, DbNil.INSTANCE);
        this.drgCache = CacheBuilder.newBuilder().maximumSize(config.getDrgCacheCapacity()).build(new CacheLoader<Long, DeployedDrg>(){

            @Override
            public DeployedDrg load(Long key) throws DrgNotFoundException {
                return DbDecisionState.this.findAndParseDecisionRequirementsByKeyFromDb(key);
            }
        });
    }

    @Override
    public Optional<PersistedDecision> findLatestDecisionById(DirectBuffer decisionId) {
        this.dbDecisionId.wrapBuffer(decisionId);
        return Optional.ofNullable(this.latestDecisionKeysByDecisionId.get(this.dbDecisionId)).flatMap(decisionKey -> this.findDecisionByKey(((DbLong)decisionKey.inner()).getValue()));
    }

    @Override
    public Optional<DeployedDrg> findLatestDecisionRequirementsById(DirectBuffer decisionRequirementsId) {
        this.dbDecisionRequirementsId.wrapBuffer(decisionRequirementsId);
        return Optional.ofNullable(this.latestDecisionRequirementsKeysById.get(this.dbDecisionRequirementsId)).map(requirementsKey -> ((DbLong)requirementsKey.inner()).getValue()).flatMap(this::findDecisionRequirementsByKey);
    }

    @Override
    public Optional<DeployedDrg> findDecisionRequirementsByKey(long decisionRequirementsKey) {
        return this.findDeployedDrg(decisionRequirementsKey);
    }

    @Override
    public List<PersistedDecision> findDecisionsByDecisionRequirementsKey(long decisionRequirementsKey) {
        ArrayList<PersistedDecision> decisions = new ArrayList<PersistedDecision>();
        this.dbDecisionRequirementsKey.wrapLong(decisionRequirementsKey);
        this.decisionKeyByDecisionRequirementsKey.whileEqualPrefix((DbKey)this.dbDecisionRequirementsKey, (key, nil) -> {
            DbForeignKey decisionKey = (DbForeignKey)key.second();
            this.findDecisionByKey(((DbLong)decisionKey.inner()).getValue()).ifPresent(decisions::add);
        });
        return decisions;
    }

    @Override
    public void clearCache() {
        this.drgCache.invalidateAll();
    }

    private DeployedDrg findAndParseDecisionRequirementsByKeyFromDb(long decisionRequirementsKey) throws DrgNotFoundException {
        this.dbDecisionRequirementsKey.wrapLong(decisionRequirementsKey);
        PersistedDecisionRequirements persistedDrg = this.decisionRequirementsByKey.get(this.dbDecisionRequirementsKey);
        if (persistedDrg == null) {
            throw new DrgNotFoundException();
        }
        PersistedDecisionRequirements copiedDrg = persistedDrg.copy();
        byte[] resourceBytes = BufferUtil.bufferAsArray(copiedDrg.getResource());
        ParsedDecisionRequirementsGraph parsedDrg = this.decisionEngine.parse(new ByteArrayInputStream(resourceBytes));
        return new DeployedDrg(parsedDrg, copiedDrg);
    }

    private Optional<DeployedDrg> findDeployedDrg(long decisionRequirementsKey) {
        try {
            return Optional.of(this.drgCache.get(decisionRequirementsKey));
        }
        catch (ExecutionException e) {
            return Optional.empty();
        }
    }

    private Optional<PersistedDecision> findDecisionByKey(long decisionKey) {
        this.dbDecisionKey.wrapLong(decisionKey);
        return Optional.ofNullable(this.decisionsByKey.get(this.dbDecisionKey)).map(PersistedDecision::copy);
    }

    @Override
    public void storeDecisionRecord(DecisionRecord record) {
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.dbPersistedDecision.wrap(record);
        this.decisionsByKey.upsert(this.dbDecisionKey, this.dbPersistedDecision);
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.decisionKeyByDecisionRequirementsKey.upsert(this.dbDecisionRequirementsKeyAndDecisionKey, DbNil.INSTANCE);
        this.updateLatestDecisionVersion(record);
    }

    @Override
    public void storeDecisionRequirements(DecisionRequirementsRecord record) {
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.dbPersistedDecisionRequirements.wrap(record);
        this.decisionRequirementsByKey.upsert(this.dbDecisionRequirementsKey, this.dbPersistedDecisionRequirements);
        this.updateLatestDecisionRequirementsVersion(record);
    }

    private void updateLatestDecisionVersion(DecisionRecord record) {
        this.findLatestDecisionById(record.getDecisionIdBuffer()).ifPresentOrElse(previousVersion -> {
            if (record.getVersion() > previousVersion.getVersion()) {
                this.updateDecisionAsLatestVersion(record);
            }
        }, () -> this.insertDecisionAsLatestVersion(record));
    }

    private void updateDecisionAsLatestVersion(DecisionRecord record) {
        this.dbDecisionId.wrapBuffer(record.getDecisionIdBuffer());
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.latestDecisionKeysByDecisionId.update(this.dbDecisionId, this.fkDecision);
    }

    private void insertDecisionAsLatestVersion(DecisionRecord record) {
        this.dbDecisionId.wrapBuffer(record.getDecisionIdBuffer());
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.latestDecisionKeysByDecisionId.upsert(this.dbDecisionId, this.fkDecision);
    }

    private void updateLatestDecisionRequirementsVersion(DecisionRequirementsRecord record) {
        this.findLatestDecisionRequirementsById(record.getDecisionRequirementsIdBuffer()).ifPresentOrElse(previousVersion -> {
            if (record.getDecisionRequirementsVersion() > previousVersion.getDecisionRequirementsVersion()) {
                this.updateDecisionRequirementsAsLatestVersion(record);
            }
        }, () -> this.insertDecisionRequirementsAsLatestVersion(record));
    }

    private void updateDecisionRequirementsAsLatestVersion(DecisionRequirementsRecord record) {
        this.dbDecisionRequirementsId.wrapBuffer(record.getDecisionRequirementsIdBuffer());
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.latestDecisionRequirementsKeysById.update(this.dbDecisionRequirementsId, this.fkDecisionRequirements);
    }

    private void insertDecisionRequirementsAsLatestVersion(DecisionRequirementsRecord record) {
        this.dbDecisionRequirementsId.wrapBuffer(record.getDecisionRequirementsIdBuffer());
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.latestDecisionRequirementsKeysById.upsert(this.dbDecisionRequirementsId, this.fkDecisionRequirements);
    }

    private static final class DrgNotFoundException
    extends Exception {
        private DrgNotFoundException() {
        }
    }
}

