/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.processing.deployment.model.BpmnFactory;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.BpmnTransformer;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.deployment.Digest;
import io.camunda.zeebe.engine.state.deployment.PersistedProcess;
import io.camunda.zeebe.engine.state.deployment.ProcessVersionManager;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.io.DirectBufferInputStream;

public final class DbProcessState
implements MutableProcessState {
    private static final int DEFAULT_VERSION_VALUE = 0;
    private final BpmnTransformer transformer = BpmnFactory.createTransformer();
    private final ProcessRecord processRecordForDeployments = new ProcessRecord();
    private final Map<DirectBuffer, Long2ObjectHashMap<DeployedProcess>> processesByProcessIdAndVersion = new HashMap<DirectBuffer, Long2ObjectHashMap<DeployedProcess>>();
    private final Long2ObjectHashMap<DeployedProcess> processesByKey;
    private final ColumnFamily<DbLong, PersistedProcess> processColumnFamily;
    private final DbLong processDefinitionKey;
    private final PersistedProcess persistedProcess;
    private final ColumnFamily<DbCompositeKey<DbString, DbLong>, PersistedProcess> processByIdAndVersionColumnFamily;
    private final DbLong processVersion;
    private final DbCompositeKey<DbString, DbLong> idAndVersionKey;
    private final DbString processId;
    private final DbForeignKey<DbString> fkProcessId;
    private final ColumnFamily<DbForeignKey<DbString>, Digest> digestByIdColumnFamily;
    private final Digest digest = new Digest();
    private final ProcessVersionManager versionManager;

    public DbProcessState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.processDefinitionKey = new DbLong();
        this.persistedProcess = new PersistedProcess();
        this.processColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.PROCESS_CACHE, transactionContext, this.processDefinitionKey, this.persistedProcess);
        this.processId = new DbString();
        this.processVersion = new DbLong();
        this.idAndVersionKey = new DbCompositeKey<DbString, DbLong>(this.processId, this.processVersion);
        this.processByIdAndVersionColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.PROCESS_CACHE_BY_ID_AND_VERSION, transactionContext, this.idAndVersionKey, this.persistedProcess);
        this.fkProcessId = new DbForeignKey<DbString>(this.processId, ZbColumnFamilies.PROCESS_CACHE_BY_ID_AND_VERSION, DbForeignKey.MatchType.Prefix);
        this.digestByIdColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.PROCESS_CACHE_DIGEST_BY_ID, transactionContext, this.fkProcessId, this.digest);
        this.processesByKey = new Long2ObjectHashMap();
        this.versionManager = new ProcessVersionManager(0L, zeebeDb, transactionContext);
    }

    @Override
    public void putDeployment(DeploymentRecord deploymentRecord) {
        for (ProcessMetadata metadata : deploymentRecord.processesMetadata()) {
            for (DeploymentResource resource : deploymentRecord.getResources()) {
                if (!resource.getResourceName().equals(metadata.getResourceName())) continue;
                this.processRecordForDeployments.reset();
                this.processRecordForDeployments.wrap(metadata, resource.getResource());
                this.putProcess(metadata.getKey(), this.processRecordForDeployments);
            }
        }
    }

    @Override
    public void putLatestVersionDigest(DirectBuffer processIdBuffer, DirectBuffer digest) {
        this.processId.wrapBuffer(processIdBuffer);
        this.digest.set(digest);
        this.digestByIdColumnFamily.upsert(this.fkProcessId, this.digest);
    }

    @Override
    public void putProcess(long key, ProcessRecord processRecord) {
        this.persistProcess(key, processRecord);
        this.updateLatestVersion(processRecord);
        this.putLatestVersionDigest(processRecord.getBpmnProcessIdBuffer(), processRecord.getChecksumBuffer());
    }

    private void persistProcess(long processDefinitionKey, ProcessRecord processRecord) {
        this.persistedProcess.wrap(processRecord, processDefinitionKey);
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        this.processColumnFamily.upsert(this.processDefinitionKey, this.persistedProcess);
        this.processId.wrapBuffer(processRecord.getBpmnProcessIdBuffer());
        this.processVersion.wrapLong(processRecord.getVersion());
        this.processByIdAndVersionColumnFamily.upsert(this.idAndVersionKey, this.persistedProcess);
    }

    private void updateLatestVersion(ProcessRecord processRecord) {
        this.processId.wrapBuffer(processRecord.getBpmnProcessIdBuffer());
        String bpmnProcessId = processRecord.getBpmnProcessId();
        long currentVersion = this.versionManager.getCurrentProcessVersion(bpmnProcessId);
        int nextVersion = processRecord.getVersion();
        if ((long)nextVersion > currentVersion) {
            this.versionManager.setProcessVersion(bpmnProcessId, nextVersion);
        }
    }

    private DeployedProcess updateInMemoryState(PersistedProcess persistedProcess) {
        byte[] bytes = new byte[persistedProcess.getLength()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        persistedProcess.write(buffer, 0);
        PersistedProcess copiedProcess = new PersistedProcess();
        copiedProcess.wrap(buffer, 0, persistedProcess.getLength());
        BpmnModelInstance modelInstance = this.readModelInstanceFromBuffer(copiedProcess.getResource());
        List<ExecutableProcess> definitions = this.transformer.transformDefinitions(modelInstance);
        ExecutableProcess executableProcess = definitions.stream().filter(process -> BufferUtil.equals(persistedProcess.getBpmnProcessId(), process.getId())).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("Expected to find executable process in persisted process with key '%s', but after transformation no such executable process could be found.", persistedProcess.getKey())));
        DeployedProcess deployedProcess = new DeployedProcess(executableProcess, copiedProcess);
        this.addProcessToInMemoryState(deployedProcess);
        return deployedProcess;
    }

    private BpmnModelInstance readModelInstanceFromBuffer(DirectBuffer buffer) {
        try (DirectBufferInputStream stream = new DirectBufferInputStream(buffer);){
            BpmnModelInstance bpmnModelInstance = Bpmn.readModelFromStream(stream);
            return bpmnModelInstance;
        }
    }

    private void addProcessToInMemoryState(DeployedProcess deployedProcess) {
        DirectBuffer bpmnProcessId = deployedProcess.getBpmnProcessId();
        this.processesByKey.put(deployedProcess.getKey(), deployedProcess);
        Long2ObjectHashMap versionMap = this.processesByProcessIdAndVersion.computeIfAbsent(bpmnProcessId, id -> new Long2ObjectHashMap());
        int version = deployedProcess.getVersion();
        versionMap.put(version, deployedProcess);
    }

    @Override
    public DeployedProcess getLatestProcessVersionByProcessId(DirectBuffer processIdBuffer) {
        DeployedProcess deployedProcess;
        Long2ObjectHashMap<DeployedProcess> versionMap = this.processesByProcessIdAndVersion.get(processIdBuffer);
        this.processId.wrapBuffer(processIdBuffer);
        long latestVersion = this.versionManager.getCurrentProcessVersion(processIdBuffer);
        if (versionMap == null) {
            deployedProcess = this.lookupProcessByIdAndPersistedVersion(latestVersion);
        } else {
            deployedProcess = versionMap.get(latestVersion);
            if (deployedProcess == null) {
                deployedProcess = this.lookupProcessByIdAndPersistedVersion(latestVersion);
            }
        }
        return deployedProcess;
    }

    @Override
    public DeployedProcess getProcessByProcessIdAndVersion(DirectBuffer processId, int version) {
        Long2ObjectHashMap<DeployedProcess> versionMap = this.processesByProcessIdAndVersion.get(processId);
        if (versionMap != null) {
            DeployedProcess deployedProcess = versionMap.get(version);
            return deployedProcess != null ? deployedProcess : this.lookupPersistenceState(processId, version);
        }
        return this.lookupPersistenceState(processId, version);
    }

    @Override
    public DeployedProcess getProcessByKey(long key) {
        DeployedProcess deployedProcess = this.processesByKey.get(key);
        if (deployedProcess != null) {
            return deployedProcess;
        }
        return this.lookupPersistenceStateForProcessByKey(key);
    }

    @Override
    public Collection<DeployedProcess> getProcesses() {
        this.updateCompleteInMemoryState();
        return this.processesByKey.values();
    }

    @Override
    public Collection<DeployedProcess> getProcessesByBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.updateCompleteInMemoryState();
        Long2ObjectHashMap<DeployedProcess> processesByVersions = this.processesByProcessIdAndVersion.get(bpmnProcessId);
        if (processesByVersions != null) {
            return processesByVersions.values();
        }
        return Collections.emptyList();
    }

    @Override
    public DirectBuffer getLatestVersionDigest(DirectBuffer processIdBuffer) {
        this.processId.wrapBuffer(processIdBuffer);
        Digest latestDigest = this.digestByIdColumnFamily.get(this.fkProcessId);
        return latestDigest == null || this.digest.get().byteArray() == null ? null : latestDigest.get();
    }

    @Override
    public int getProcessVersion(String bpmnProcessId) {
        return (int)this.versionManager.getCurrentProcessVersion(bpmnProcessId);
    }

    @Override
    public <T extends ExecutableFlowElement> T getFlowElement(long processDefinitionKey, DirectBuffer elementId, Class<T> elementType) {
        DeployedProcess deployedProcess = this.getProcessByKey(processDefinitionKey);
        if (deployedProcess == null) {
            throw new IllegalStateException(String.format("Expected to find a process deployed with key '%d' but not found.", processDefinitionKey));
        }
        ExecutableProcess process = deployedProcess.getProcess();
        T element = process.getElementById(elementId, elementType);
        if (element == null) {
            throw new IllegalStateException(String.format("Expected to find a flow element with id '%s' in process with key '%d' but not found.", BufferUtil.bufferAsString(elementId), processDefinitionKey));
        }
        return element;
    }

    @Override
    public void clearCache() {
        this.processesByKey.clear();
        this.processesByProcessIdAndVersion.clear();
        this.versionManager.clear();
    }

    private DeployedProcess lookupProcessByIdAndPersistedVersion(long latestVersion) {
        this.processVersion.wrapLong(latestVersion);
        PersistedProcess processWithVersionAndId = this.processByIdAndVersionColumnFamily.get(this.idAndVersionKey);
        if (processWithVersionAndId != null) {
            return this.updateInMemoryState(processWithVersionAndId);
        }
        return null;
    }

    private DeployedProcess lookupPersistenceState(DirectBuffer processIdBuffer, int version) {
        this.processId.wrapBuffer(processIdBuffer);
        this.processVersion.wrapLong(version);
        PersistedProcess processWithVersionAndId = this.processByIdAndVersionColumnFamily.get(this.idAndVersionKey);
        if (processWithVersionAndId != null) {
            this.updateInMemoryState(processWithVersionAndId);
            Long2ObjectHashMap<DeployedProcess> newVersionMap = this.processesByProcessIdAndVersion.get(processIdBuffer);
            if (newVersionMap != null) {
                return newVersionMap.get(version);
            }
        }
        return null;
    }

    private DeployedProcess lookupPersistenceStateForProcessByKey(long processDefinitionKey) {
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        PersistedProcess processWithKey = this.processColumnFamily.get(this.processDefinitionKey);
        if (processWithKey != null) {
            this.updateInMemoryState(processWithKey);
            return this.processesByKey.get(processDefinitionKey);
        }
        return null;
    }

    private void updateCompleteInMemoryState() {
        this.processColumnFamily.forEach(this::updateInMemoryState);
    }
}

