/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.NextValue;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import org.agrona.DirectBuffer;
import org.agrona.collections.Object2LongHashMap;

public final class ProcessVersionManager {
    private final long initialValue;
    private final ColumnFamily<DbString, NextValue> nextValueColumnFamily;
    private final DbString processIdKey;
    private final NextValue nextVersion = new NextValue();
    private final Object2LongHashMap<String> versionCache;

    public ProcessVersionManager(long initialValue, ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.initialValue = initialValue;
        this.processIdKey = new DbString();
        this.nextValueColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.PROCESS_VERSION, transactionContext, this.processIdKey, this.nextVersion);
        this.versionCache = new Object2LongHashMap(initialValue);
    }

    public void setProcessVersion(String processId, long value) {
        this.processIdKey.wrapString(processId);
        this.nextVersion.set(value);
        this.nextValueColumnFamily.upsert(this.processIdKey, this.nextVersion);
        this.versionCache.put(processId, value);
    }

    public long getCurrentProcessVersion(String processId) {
        this.processIdKey.wrapString(processId);
        return this.getCurrentProcessVersion();
    }

    public long getCurrentProcessVersion(DirectBuffer processId) {
        this.processIdKey.wrapBuffer(processId);
        return this.getCurrentProcessVersion();
    }

    private long getCurrentProcessVersion() {
        return this.versionCache.computeIfAbsent(this.processIdKey.toString(), key -> this.getProcessVersionFromDB());
    }

    private long getProcessVersionFromDB() {
        NextValue readValue = this.nextValueColumnFamily.get(this.processIdKey);
        long currentValue = this.initialValue;
        if (readValue != null) {
            currentValue = readValue.get();
        }
        return currentValue;
    }

    public void clear() {
        this.versionCache.clear();
    }
}

