/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.instance.AwaitProcessInstanceResultMetadata;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableVariableState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.collections.MutableInteger;
import org.agrona.concurrent.UnsafeBuffer;

public final class DbElementInstanceState
implements MutableElementInstanceState {
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>>, DbNil> parentChildColumnFamily;
    private final DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>> parentChildKey;
    private final DbForeignKey<DbLong> parentKey;
    private final DbLong elementInstanceKey;
    private final ElementInstance elementInstance;
    private final ColumnFamily<DbLong, ElementInstance> elementInstanceColumnFamily;
    private final AwaitProcessInstanceResultMetadata awaitResultMetadata;
    private final ColumnFamily<DbLong, AwaitProcessInstanceResultMetadata> awaitProcessInstanceResultMetadataColumnFamily;
    private final DbLong flowScopeKey = new DbLong();
    private final DbString gatewayElementId = new DbString();
    private final DbString sequenceFlowElementId = new DbString();
    private final DbInt numberOfTakenSequenceFlows = new DbInt();
    private final DbCompositeKey<DbLong, DbString> flowScopeKeyAndElementId;
    private final DbCompositeKey<DbCompositeKey<DbLong, DbString>, DbString> numberOfTakenSequenceFlowsKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbLong, DbString>, DbString>, DbInt> numberOfTakenSequenceFlowsColumnFamily;
    private final MutableVariableState variableState;

    public DbElementInstanceState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, MutableVariableState variableState) {
        this.variableState = variableState;
        this.elementInstanceKey = new DbLong();
        this.parentKey = new DbForeignKey<DbLong>(new DbLong(), ZbColumnFamilies.ELEMENT_INSTANCE_KEY, DbForeignKey.MatchType.Full, k -> k.getValue() == -1L);
        this.parentChildKey = new DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>>(this.parentKey, new DbForeignKey<DbLong>(this.elementInstanceKey, ZbColumnFamilies.ELEMENT_INSTANCE_KEY));
        this.parentChildColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.ELEMENT_INSTANCE_PARENT_CHILD, transactionContext, this.parentChildKey, DbNil.INSTANCE);
        this.elementInstance = new ElementInstance();
        this.elementInstanceColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.ELEMENT_INSTANCE_KEY, transactionContext, this.elementInstanceKey, this.elementInstance);
        this.awaitResultMetadata = new AwaitProcessInstanceResultMetadata();
        this.awaitProcessInstanceResultMetadataColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.AWAIT_WORKLOW_RESULT, transactionContext, this.elementInstanceKey, this.awaitResultMetadata);
        this.flowScopeKeyAndElementId = new DbCompositeKey<DbLong, DbString>(this.flowScopeKey, this.gatewayElementId);
        this.numberOfTakenSequenceFlowsKey = new DbCompositeKey<DbCompositeKey<DbLong, DbString>, DbString>(this.flowScopeKeyAndElementId, this.sequenceFlowElementId);
        this.numberOfTakenSequenceFlowsColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.NUMBER_OF_TAKEN_SEQUENCE_FLOWS, transactionContext, this.numberOfTakenSequenceFlowsKey, this.numberOfTakenSequenceFlows);
    }

    @Override
    public ElementInstance newInstance(long key, ProcessInstanceRecord value, ProcessInstanceIntent state) {
        return this.newInstance(null, key, value, state);
    }

    @Override
    public ElementInstance newInstance(ElementInstance parent, long key, ProcessInstanceRecord value, ProcessInstanceIntent state) {
        ElementInstance instance;
        if (parent == null) {
            instance = new ElementInstance(key, state, value);
        } else {
            instance = new ElementInstance(key, parent, state, value);
            this.updateInstance(parent);
        }
        this.createInstance(instance);
        return instance;
    }

    @Override
    public void removeInstance(long key) {
        ElementInstance instance = this.getInstance(key);
        if (instance != null) {
            this.elementInstanceKey.wrapLong(key);
            this.parentKey.inner().wrapLong(instance.getParentKey());
            this.parentChildColumnFamily.deleteIfExists(this.parentChildKey);
            this.elementInstanceColumnFamily.deleteExisting(this.elementInstanceKey);
            this.variableState.removeScope(key);
            this.awaitProcessInstanceResultMetadataColumnFamily.deleteIfExists(this.elementInstanceKey);
            this.removeNumberOfTakenSequenceFlows(key);
            long parentKey = instance.getParentKey();
            if (parentKey > 0L) {
                ElementInstance parentInstance = this.getInstance(parentKey);
                if (parentInstance == null) {
                    String errorMsg = "Expected to find parent instance for element instance with key %d, but none was found.";
                    throw new IllegalStateException(String.format("Expected to find parent instance for element instance with key %d, but none was found.", parentKey));
                }
                parentInstance.decrementChildCount();
                this.updateInstance(parentInstance);
            }
        }
    }

    @Override
    public void createInstance(ElementInstance instance) {
        this.elementInstanceKey.wrapLong(instance.getKey());
        this.parentKey.inner().wrapLong(instance.getParentKey());
        this.elementInstanceColumnFamily.insert(this.elementInstanceKey, instance);
        this.parentChildColumnFamily.insert(this.parentChildKey, DbNil.INSTANCE);
        this.variableState.createScope(this.elementInstanceKey.getValue(), this.parentKey.inner().getValue());
    }

    @Override
    public void updateInstance(ElementInstance scopeInstance) {
        this.elementInstanceKey.wrapLong(scopeInstance.getKey());
        this.parentKey.inner().wrapLong(scopeInstance.getParentKey());
        this.elementInstanceColumnFamily.update(this.elementInstanceKey, scopeInstance);
    }

    @Override
    public void updateInstance(long key, Consumer<ElementInstance> modifier) {
        ElementInstance scopeInstance = this.getInstance(key);
        modifier.accept(scopeInstance);
        this.updateInstance(scopeInstance);
    }

    @Override
    public void setAwaitResultRequestMetadata(long processInstanceKey, AwaitProcessInstanceResultMetadata metadata) {
        this.elementInstanceKey.wrapLong(processInstanceKey);
        this.awaitProcessInstanceResultMetadataColumnFamily.insert(this.elementInstanceKey, metadata);
    }

    @Override
    public void incrementNumberOfTakenSequenceFlows(long flowScopeKey, DirectBuffer gatewayElementId, DirectBuffer sequenceFlowElementId) {
        this.flowScopeKey.wrapLong(flowScopeKey);
        this.gatewayElementId.wrapBuffer(gatewayElementId);
        this.sequenceFlowElementId.wrapBuffer(sequenceFlowElementId);
        DbInt number = this.numberOfTakenSequenceFlowsColumnFamily.get(this.numberOfTakenSequenceFlowsKey);
        int newValue = 1;
        if (number != null) {
            newValue = number.getValue() + 1;
        }
        this.numberOfTakenSequenceFlows.wrapInt(newValue);
        this.numberOfTakenSequenceFlowsColumnFamily.upsert(this.numberOfTakenSequenceFlowsKey, this.numberOfTakenSequenceFlows);
    }

    @Override
    public void decrementNumberOfTakenSequenceFlows(long flowScopeKey, DirectBuffer gatewayElementId) {
        this.flowScopeKey.wrapLong(flowScopeKey);
        this.gatewayElementId.wrapBuffer(gatewayElementId);
        this.numberOfTakenSequenceFlowsColumnFamily.whileEqualPrefix(this.flowScopeKeyAndElementId, (key, number) -> {
            int newValue = number.getValue() - 1;
            if (newValue > 0) {
                this.numberOfTakenSequenceFlows.wrapInt(newValue);
                this.numberOfTakenSequenceFlowsColumnFamily.update((DbCompositeKey<DbCompositeKey<DbLong, DbString>, DbString>)key, this.numberOfTakenSequenceFlows);
            } else {
                this.numberOfTakenSequenceFlowsColumnFamily.deleteExisting((DbCompositeKey<DbCompositeKey<DbLong, DbString>, DbString>)key);
            }
        });
    }

    @Override
    public ElementInstance getInstance(long key) {
        this.elementInstanceKey.wrapLong(key);
        ElementInstance elementInstance = this.elementInstanceColumnFamily.get(this.elementInstanceKey);
        return this.copyElementInstance(elementInstance);
    }

    @Override
    public List<ElementInstance> getChildren(long parentKey) {
        ArrayList<ElementInstance> children = new ArrayList<ElementInstance>();
        ElementInstance parentInstance = this.getInstance(parentKey);
        if (parentInstance != null) {
            this.parentKey.inner().wrapLong(parentKey);
            this.parentChildColumnFamily.whileEqualPrefix(this.parentKey, (key, value) -> {
                DbLong childKey = (DbLong)((DbForeignKey)key.second()).inner();
                ElementInstance childInstance = this.getInstance(childKey.getValue());
                ElementInstance copiedElementInstance = this.copyElementInstance(childInstance);
                children.add(copiedElementInstance);
            });
        }
        return children;
    }

    @Override
    public void forEachChild(long parentKey, long startAtKey, BiFunction<Long, ElementInstance, Boolean> visitor) {
        this.parentKey.inner().wrapLong(parentKey);
        this.elementInstanceKey.wrapLong(startAtKey);
        DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>> compositeKey = startAtKey == -1L ? null : this.parentChildKey;
        this.parentChildColumnFamily.whileEqualPrefix(this.parentKey, compositeKey, (key, value) -> {
            DbLong childKey = (DbLong)((DbForeignKey)key.second()).inner();
            ElementInstance childInstance = this.getInstance(childKey.getValue());
            return (Boolean)visitor.apply(childKey.getValue(), childInstance);
        });
    }

    @Override
    public AwaitProcessInstanceResultMetadata getAwaitResultRequestMetadata(long processInstanceKey) {
        this.elementInstanceKey.wrapLong(processInstanceKey);
        return this.awaitProcessInstanceResultMetadataColumnFamily.get(this.elementInstanceKey);
    }

    @Override
    public int getNumberOfTakenSequenceFlows(long flowScopeKey, DirectBuffer gatewayElementId) {
        this.flowScopeKey.wrapLong(flowScopeKey);
        this.gatewayElementId.wrapBuffer(gatewayElementId);
        MutableInteger count = new MutableInteger(0);
        this.numberOfTakenSequenceFlowsColumnFamily.whileEqualPrefix(this.flowScopeKeyAndElementId, (key, number) -> count.increment());
        return count.get();
    }

    private ElementInstance copyElementInstance(ElementInstance elementInstance) {
        if (elementInstance != null) {
            byte[] bytes = new byte[elementInstance.getLength()];
            UnsafeBuffer buffer = new UnsafeBuffer(bytes);
            elementInstance.write(buffer, 0);
            ElementInstance copiedElementInstance = new ElementInstance();
            copiedElementInstance.wrap(buffer, 0, elementInstance.getLength());
            return copiedElementInstance;
        }
        return null;
    }

    private void removeNumberOfTakenSequenceFlows(long flowScopeKey) {
        this.flowScopeKey.wrapLong(flowScopeKey);
        this.numberOfTakenSequenceFlowsColumnFamily.whileEqualPrefix((DbKey)this.flowScopeKey, (key, number) -> this.numberOfTakenSequenceFlowsColumnFamily.deleteExisting((DbCompositeKey<DbCompositeKey<DbLong, DbString>, DbString>)key));
    }
}

