/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.engine.metrics.IncidentMetrics;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.instance.Incident;
import io.camunda.zeebe.engine.state.instance.IncidentKey;
import io.camunda.zeebe.engine.state.mutable.MutableIncidentState;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import java.util.function.ObjLongConsumer;

public final class DbIncidentState
implements MutableIncidentState {
    public static final int MISSING_INCIDENT = -1;
    private final DbLong incidentKey;
    private final Incident incidentRead = new Incident();
    private final Incident incidentWrite = new Incident();
    private final ColumnFamily<DbLong, Incident> incidentColumnFamily;
    private final DbForeignKey<DbLong> elementInstanceKey;
    private final ColumnFamily<DbForeignKey<DbLong>, IncidentKey> processInstanceIncidentColumnFamily;
    private final DbForeignKey<DbLong> jobKey;
    private final ColumnFamily<DbForeignKey<DbLong>, IncidentKey> jobIncidentColumnFamily;
    private final IncidentKey incidentKeyValue = new IncidentKey();
    private final IncidentMetrics metrics;

    public DbIncidentState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, int partitionId) {
        this.incidentKey = new DbLong();
        this.incidentColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.INCIDENTS, transactionContext, this.incidentKey, this.incidentRead);
        this.elementInstanceKey = new DbForeignKey<DbLong>(new DbLong(), ZbColumnFamilies.ELEMENT_INSTANCE_KEY);
        this.processInstanceIncidentColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.INCIDENT_PROCESS_INSTANCES, transactionContext, this.elementInstanceKey, this.incidentKeyValue);
        this.jobKey = new DbForeignKey<DbLong>(new DbLong(), ZbColumnFamilies.JOBS);
        this.jobIncidentColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.INCIDENT_JOBS, transactionContext, this.jobKey, this.incidentKeyValue);
        this.metrics = new IncidentMetrics(partitionId);
    }

    @Override
    public void createIncident(long incidentKey, IncidentRecord incident) {
        this.incidentKey.wrapLong(incidentKey);
        this.incidentWrite.setRecord(incident);
        this.incidentColumnFamily.insert(this.incidentKey, this.incidentWrite);
        this.incidentKeyValue.set(incidentKey);
        if (this.isJobIncident(incident)) {
            this.jobKey.inner().wrapLong(incident.getJobKey());
            this.jobIncidentColumnFamily.insert(this.jobKey, this.incidentKeyValue);
        } else {
            this.elementInstanceKey.inner().wrapLong(incident.getElementInstanceKey());
            this.processInstanceIncidentColumnFamily.insert(this.elementInstanceKey, this.incidentKeyValue);
        }
        this.metrics.incidentCreated();
    }

    @Override
    public void deleteIncident(long key) {
        IncidentRecord incidentRecord = this.getIncidentRecord(key);
        if (incidentRecord != null) {
            this.incidentColumnFamily.deleteExisting(this.incidentKey);
            if (this.isJobIncident(incidentRecord)) {
                this.jobKey.inner().wrapLong(incidentRecord.getJobKey());
                this.jobIncidentColumnFamily.deleteExisting(this.jobKey);
            } else {
                this.elementInstanceKey.inner().wrapLong(incidentRecord.getElementInstanceKey());
                this.processInstanceIncidentColumnFamily.deleteExisting(this.elementInstanceKey);
            }
            this.metrics.incidentResolved();
        }
    }

    @Override
    public IncidentRecord getIncidentRecord(long incidentKey) {
        this.incidentKey.wrapLong(incidentKey);
        Incident incident = this.incidentColumnFamily.get(this.incidentKey);
        if (incident != null) {
            return incident.getRecord();
        }
        return null;
    }

    @Override
    public long getProcessInstanceIncidentKey(long processInstanceKey) {
        this.elementInstanceKey.inner().wrapLong(processInstanceKey);
        IncidentKey incidentKey = this.processInstanceIncidentColumnFamily.get(this.elementInstanceKey);
        if (incidentKey != null) {
            return incidentKey.get();
        }
        return -1L;
    }

    @Override
    public long getJobIncidentKey(long jobKey) {
        this.jobKey.inner().wrapLong(jobKey);
        IncidentKey incidentKey = this.jobIncidentColumnFamily.get(this.jobKey);
        if (incidentKey != null) {
            return incidentKey.get();
        }
        return -1L;
    }

    @Override
    public boolean isJobIncident(IncidentRecord record) {
        return record.getJobKey() > 0L;
    }

    @Override
    public void forExistingProcessIncident(long elementInstanceKey, ObjLongConsumer<IncidentRecord> resolver) {
        boolean hasIncident;
        long processIncidentKey = this.getProcessInstanceIncidentKey(elementInstanceKey);
        boolean bl = hasIncident = processIncidentKey != -1L;
        if (hasIncident) {
            IncidentRecord incidentRecord = this.getIncidentRecord(processIncidentKey);
            resolver.accept(incidentRecord, processIncidentKey);
        }
    }
}

