/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.instance.JobRecordValue;
import io.camunda.zeebe.engine.state.instance.JobStateValue;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.util.EnsureUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.slf4j.Logger;

public final class DbJobState
implements JobState,
MutableJobState {
    private static final Logger LOG = Loggers.PROCESS_PROCESSOR_LOGGER;
    private final JobRecordValue jobRecordToRead = new JobRecordValue();
    private final JobRecordValue jobRecordToWrite = new JobRecordValue();
    private final DbLong jobKey;
    private final DbForeignKey<DbLong> fkJob;
    private final ColumnFamily<DbLong, JobRecordValue> jobsColumnFamily;
    private final JobStateValue jobState = new JobStateValue();
    private final ColumnFamily<DbForeignKey<DbLong>, JobStateValue> statesJobColumnFamily;
    private final DbString jobTypeKey;
    private final DbCompositeKey<DbString, DbForeignKey<DbLong>> typeJobKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbForeignKey<DbLong>>, DbNil> activatableColumnFamily;
    private final DbLong deadlineKey;
    private final DbCompositeKey<DbLong, DbForeignKey<DbLong>> deadlineJobKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> deadlinesColumnFamily;
    private final DbLong backoffKey;
    private final DbCompositeKey<DbLong, DbForeignKey<DbLong>> backoffJobKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> backoffColumnFamily;
    private long nextBackOffDueDate;
    private final JobMetrics metrics;
    private Consumer<String> onJobsAvailableCallback;

    public DbJobState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, int partitionId) {
        this.jobKey = new DbLong();
        this.fkJob = new DbForeignKey<DbLong>(this.jobKey, ZbColumnFamilies.JOBS);
        this.jobsColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.JOBS, transactionContext, this.jobKey, this.jobRecordToRead);
        this.statesJobColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.JOB_STATES, transactionContext, this.fkJob, this.jobState);
        this.jobTypeKey = new DbString();
        this.typeJobKey = new DbCompositeKey<DbString, DbForeignKey<DbLong>>(this.jobTypeKey, this.fkJob);
        this.activatableColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.JOB_ACTIVATABLE, transactionContext, this.typeJobKey, DbNil.INSTANCE);
        this.deadlineKey = new DbLong();
        this.deadlineJobKey = new DbCompositeKey<DbLong, DbForeignKey<DbLong>>(this.deadlineKey, this.fkJob);
        this.deadlinesColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.JOB_DEADLINES, transactionContext, this.deadlineJobKey, DbNil.INSTANCE);
        this.backoffKey = new DbLong();
        this.backoffJobKey = new DbCompositeKey<DbLong, DbForeignKey<DbLong>>(this.backoffKey, this.fkJob);
        this.backoffColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.JOB_BACKOFF, transactionContext, this.backoffJobKey, DbNil.INSTANCE);
        this.metrics = new JobMetrics(partitionId);
    }

    @Override
    public void create(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        this.createJob(key, record, type);
    }

    @Override
    public void activate(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        long deadline = record.getDeadline();
        this.validateParameters(type);
        EnsureUtil.ensureGreaterThan("deadline", deadline, 0L);
        this.updateJobRecord(key, record);
        this.updateJobState(JobState.State.ACTIVATED);
        this.makeJobNotActivatable(type);
        this.addJobDeadline(key, deadline);
    }

    @Override
    public void recurAfterBackoff(long key, JobRecord record) {
        this.updateJob(key, record, JobState.State.ACTIVATABLE);
        this.removeJobBackoff(key, record.getRecurringTime());
    }

    @Override
    public void timeout(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        long deadline = record.getDeadline();
        this.validateParameters(type);
        EnsureUtil.ensureGreaterThan("deadline", deadline, 0L);
        this.updateJob(key, record, JobState.State.ACTIVATABLE);
    }

    @Override
    public void complete(long key, JobRecord record) {
        this.delete(key, record);
    }

    @Override
    public void cancel(long key, JobRecord record) {
        this.delete(key, record);
    }

    @Override
    public void disable(long key, JobRecord record) {
        this.updateJob(key, record, JobState.State.FAILED);
        this.makeJobNotActivatable(record.getTypeBuffer());
    }

    @Override
    public void throwError(long key, JobRecord updatedValue) {
        this.updateJob(key, updatedValue, JobState.State.ERROR_THROWN);
        this.makeJobNotActivatable(updatedValue.getTypeBuffer());
    }

    @Override
    public void delete(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        this.jobKey.wrapLong(key);
        this.jobsColumnFamily.deleteExisting(this.jobKey);
        this.statesJobColumnFamily.deleteExisting(this.fkJob);
        this.makeJobNotActivatable(type);
        this.removeJobDeadline(key, record.getDeadline());
        this.removeJobBackoff(key, record.getRecurringTime());
    }

    @Override
    public void fail(long key, JobRecord updatedValue) {
        if (updatedValue.getRetries() > 0) {
            if (updatedValue.getRetryBackoff() > 0L) {
                this.addJobBackoff(key, updatedValue.getRecurringTime());
                this.updateJob(key, updatedValue, JobState.State.FAILED);
            } else {
                this.updateJob(key, updatedValue, JobState.State.ACTIVATABLE);
            }
        } else {
            this.updateJob(key, updatedValue, JobState.State.FAILED);
            this.makeJobNotActivatable(updatedValue.getTypeBuffer());
        }
    }

    @Override
    public void resolve(long key, JobRecord updatedValue) {
        this.updateJob(key, updatedValue, JobState.State.ACTIVATABLE);
    }

    @Override
    public JobRecord updateJobRetries(long jobKey, int retries) {
        JobRecord job = this.getJob(jobKey);
        if (job != null) {
            job.setRetries(retries);
            this.updateJobRecord(jobKey, job);
        }
        return job;
    }

    @Override
    public void cleanupTimeoutsWithoutJobs() {
        this.deadlinesColumnFamily.whileTrue((key, value) -> {
            DbLong jobKey = (DbLong)((DbForeignKey)key.second()).inner();
            long deadline = ((DbLong)key.first()).getValue();
            JobRecordValue job = this.jobsColumnFamily.get(jobKey);
            if (job == null || job.getRecord().getDeadline() != deadline) {
                this.deadlinesColumnFamily.deleteExisting((DbCompositeKey<DbLong, DbForeignKey<DbLong>>)key);
            }
            return true;
        });
    }

    @Override
    public void cleanupBackoffsWithoutJobs() {
        this.backoffColumnFamily.whileTrue((key, value) -> {
            DbLong jobKey = (DbLong)((DbForeignKey)key.second()).inner();
            long backoff = ((DbLong)key.first()).getValue();
            JobRecordValue job = this.jobsColumnFamily.get(jobKey);
            if (job == null || job.getRecord().getRetryBackoff() != backoff) {
                this.backoffColumnFamily.deleteExisting((DbCompositeKey<DbLong, DbForeignKey<DbLong>>)key);
            }
            return true;
        });
    }

    private void createJob(long key, JobRecord record, DirectBuffer type) {
        this.createJobRecord(key, record);
        this.initializeJobState();
        this.makeJobActivatable(type, key);
    }

    private void updateJob(long key, JobRecord updatedValue, JobState.State newState) {
        DirectBuffer type = updatedValue.getTypeBuffer();
        this.validateParameters(type);
        this.updateJobRecord(key, updatedValue);
        this.updateJobState(newState);
        if (newState == JobState.State.ACTIVATABLE) {
            this.makeJobActivatable(type, key);
        }
        if (newState != JobState.State.ACTIVATED) {
            this.removeJobDeadline(key, updatedValue.getDeadline());
        }
    }

    private void validateParameters(DirectBuffer type) {
        EnsureUtil.ensureNotNullOrEmpty("type", type);
    }

    @Override
    public void forEachTimedOutEntry(long upperBound, BiPredicate<Long, JobRecord> callback) {
        this.deadlinesColumnFamily.whileTrue((key, value) -> {
            boolean isDue;
            long deadline = ((DbLong)key.first()).getValue();
            boolean bl = isDue = deadline < upperBound;
            if (isDue) {
                long jobKey1 = ((DbLong)((DbForeignKey)key.second()).inner()).getValue();
                return this.visitJob(jobKey1, callback);
            }
            return false;
        });
    }

    @Override
    public boolean exists(long jobKey) {
        this.jobKey.wrapLong(jobKey);
        return this.jobsColumnFamily.exists(this.jobKey);
    }

    @Override
    public JobState.State getState(long key) {
        this.jobKey.wrapLong(key);
        JobStateValue storedState = this.statesJobColumnFamily.get(this.fkJob);
        if (storedState == null) {
            return JobState.State.NOT_FOUND;
        }
        return storedState.getState();
    }

    @Override
    public boolean isInState(long key, JobState.State state) {
        return this.getState(key) == state;
    }

    @Override
    public void forEachActivatableJobs(DirectBuffer type, BiFunction<Long, JobRecord, Boolean> callback) {
        this.jobTypeKey.wrapBuffer(type);
        this.activatableColumnFamily.whileEqualPrefix((DbKey)this.jobTypeKey, (compositeKey, zbNil) -> {
            long jobKey = ((DbLong)((DbForeignKey)compositeKey.second()).inner()).getValue();
            return this.visitJob(jobKey, callback::apply);
        });
    }

    @Override
    public JobRecord getJob(long key) {
        this.jobKey.wrapLong(key);
        JobRecordValue jobState = this.jobsColumnFamily.get(this.jobKey);
        return jobState == null ? null : jobState.getRecord();
    }

    @Override
    public void setJobsAvailableCallback(Consumer<String> onJobsAvailableCallback) {
        this.onJobsAvailableCallback = onJobsAvailableCallback;
    }

    @Override
    public long findBackedOffJobs(long timestamp, BiPredicate<Long, JobRecord> callback) {
        this.nextBackOffDueDate = -1L;
        this.backoffColumnFamily.whileTrue((key, value) -> {
            long deadline = ((DbLong)key.first()).getValue();
            boolean consumed = false;
            if (deadline <= timestamp) {
                long jobKey = ((DbLong)((DbForeignKey)key.second()).inner()).getValue();
                consumed = this.visitJob(jobKey, callback);
            }
            if (!consumed) {
                this.nextBackOffDueDate = deadline;
            }
            return consumed;
        });
        return this.nextBackOffDueDate;
    }

    boolean visitJob(long jobKey, BiPredicate<Long, JobRecord> callback) {
        JobRecord job = this.getJob(jobKey);
        if (job == null) {
            LOG.error("Expected to find job with key {}, but no job found", (Object)jobKey);
            return true;
        }
        return callback.test(jobKey, job);
    }

    private void notifyJobAvailable(DirectBuffer jobType) {
        if (this.onJobsAvailableCallback != null) {
            this.onJobsAvailableCallback.accept(BufferUtil.bufferAsString(jobType));
        }
    }

    private void createJobRecord(long key, JobRecord record) {
        this.jobKey.wrapLong(key);
        this.jobRecordToWrite.setRecordWithoutVariables(record);
        this.jobsColumnFamily.insert(this.jobKey, this.jobRecordToWrite);
    }

    private void updateJobRecord(long key, JobRecord updatedValue) {
        this.jobKey.wrapLong(key);
        this.jobRecordToWrite.setRecordWithoutVariables(updatedValue);
        this.jobsColumnFamily.update(this.jobKey, this.jobRecordToWrite);
    }

    private void initializeJobState() {
        this.jobState.setState(JobState.State.ACTIVATABLE);
        this.statesJobColumnFamily.insert(this.fkJob, this.jobState);
    }

    private void updateJobState(JobState.State newState) {
        this.jobState.setState(newState);
        this.statesJobColumnFamily.update(this.fkJob, this.jobState);
    }

    private void makeJobActivatable(DirectBuffer type, long key) {
        EnsureUtil.ensureNotNullOrEmpty("type", type);
        this.jobTypeKey.wrapBuffer(type);
        this.jobKey.wrapLong(key);
        this.activatableColumnFamily.upsert(this.typeJobKey, DbNil.INSTANCE);
        this.notifyJobAvailable(type);
    }

    private void makeJobNotActivatable(DirectBuffer type) {
        EnsureUtil.ensureNotNullOrEmpty("type", type);
        this.jobTypeKey.wrapBuffer(type);
        this.activatableColumnFamily.deleteIfExists(this.typeJobKey);
    }

    private void addJobDeadline(long job, long deadline) {
        if (deadline > 0L) {
            this.jobKey.wrapLong(job);
            this.deadlineKey.wrapLong(deadline);
            this.deadlinesColumnFamily.insert(this.deadlineJobKey, DbNil.INSTANCE);
        }
    }

    private void removeJobDeadline(long job, long deadline) {
        if (deadline > 0L) {
            this.jobKey.wrapLong(job);
            this.deadlineKey.wrapLong(deadline);
            this.deadlinesColumnFamily.deleteIfExists(this.deadlineJobKey);
        }
    }

    private void addJobBackoff(long job, long backoff) {
        if (backoff > 0L) {
            this.jobKey.wrapLong(job);
            this.backoffKey.wrapLong(backoff);
            this.backoffColumnFamily.insert(this.backoffJobKey, DbNil.INSTANCE);
        }
    }

    private void removeJobBackoff(long job, long backoff) {
        if (backoff > 0L) {
            this.jobKey.wrapLong(job);
            this.backoffKey.wrapLong(backoff);
            this.backoffColumnFamily.deleteIfExists(this.backoffJobKey);
        }
    }
}

