/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.engine.state.migration.DbMigrator;
import io.camunda.zeebe.engine.state.migration.JobBackoffCleanupMigration;
import io.camunda.zeebe.engine.state.migration.JobTimeoutCleanupMigration;
import io.camunda.zeebe.engine.state.migration.MessageSubscriptionSentTimeMigration;
import io.camunda.zeebe.engine.state.migration.MigrationTask;
import io.camunda.zeebe.engine.state.migration.ProcessMessageSubscriptionSentTimeMigration;
import io.camunda.zeebe.engine.state.migration.TemporaryVariableMigration;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbMigratorImpl
implements DbMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbMigratorImpl.class.getPackageName());
    private static final List<MigrationTask> MIGRATION_TASKS = List.of(new ProcessMessageSubscriptionSentTimeMigration(), new MessageSubscriptionSentTimeMigration(), new TemporaryVariableMigration(), new JobTimeoutCleanupMigration(), new JobBackoffCleanupMigration());
    private final MutableProcessingState processingState;
    private final Supplier<List<MigrationTask>> migrationSupplier;
    private boolean abortRequested = false;
    private MigrationTask currentMigration;

    public DbMigratorImpl(MutableProcessingState processingState) {
        this(processingState, () -> MIGRATION_TASKS);
    }

    DbMigratorImpl(MutableProcessingState processingState, Supplier<List<MigrationTask>> migrationSupplier) {
        this.processingState = processingState;
        this.migrationSupplier = migrationSupplier;
    }

    @Override
    public void runMigrations() {
        List<MigrationTask> migrationTasks = this.migrationSupplier.get();
        this.logPreview(migrationTasks);
        ArrayList<MigrationTask> executedMigrations = new ArrayList<MigrationTask>();
        for (int index = 1; index <= migrationTasks.size() && !this.abortRequested; ++index) {
            MigrationTask migration2 = migrationTasks.get(index - 1);
            boolean executed = this.handleMigrationTask(migration2, index, migrationTasks.size());
            if (!executed) continue;
            executedMigrations.add(migration2);
        }
        if (!this.abortRequested) {
            this.logSummary(executedMigrations);
        }
    }

    @Override
    public void abort() {
        String message = this.currentMigration == null ? "Received abort signal (no migration running)" : "Aborting " + this.currentMigration.getIdentifier() + " migration as requested";
        LOGGER.info(message);
        this.abortRequested = true;
    }

    private void logPreview(List<MigrationTask> migrationTasks) {
        LOGGER.info("Starting processing of migration tasks (use LogLevel.DEBUG for more details) ... ");
        LOGGER.debug("Found " + migrationTasks.size() + " migration tasks: " + migrationTasks.stream().map(MigrationTask::getIdentifier).collect(Collectors.joining(", ")));
    }

    private void logSummary(List<MigrationTask> migrationTasks) {
        LOGGER.info("Completed processing of migration tasks (use LogLevel.DEBUG for more details) ... ");
        LOGGER.debug("Executed " + migrationTasks.size() + " migration tasks: " + migrationTasks.stream().map(MigrationTask::getIdentifier).collect(Collectors.joining(", ")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleMigrationTask(MigrationTask migrationTask, int index, int total) {
        if (this.processingState.getMigrationState().isMigrationFinished(migrationTask.getIdentifier())) {
            this.logMigrationTaskAlreadyExecuted(migrationTask, index, total);
            return false;
        }
        if (!migrationTask.needsToRun(this.processingState)) {
            this.logMigrationSkipped(migrationTask, index, total);
            this.processingState.getMigrationState().markMigrationFinished(migrationTask.getIdentifier());
            return false;
        }
        try {
            this.currentMigration = migrationTask;
            this.runMigration(migrationTask, index, total);
            this.processingState.getMigrationState().markMigrationFinished(migrationTask.getIdentifier());
        }
        finally {
            this.currentMigration = null;
        }
        return true;
    }

    private void logMigrationTaskAlreadyExecuted(MigrationTask migrationTask, int index, int total) {
        LOGGER.debug("Migration was executed before " + migrationTask.getIdentifier() + " migration (" + index + "/" + total + ").  It does not need to run again.");
    }

    private void logMigrationSkipped(MigrationTask migrationTask, int index, int total) {
        LOGGER.debug("Skipping " + migrationTask.getIdentifier() + " migration (" + index + "/" + total + ").  It was determined it does not need to run right now.");
    }

    private void runMigration(MigrationTask migrationTask, int index, int total) {
        LOGGER.debug("Starting " + migrationTask.getIdentifier() + " migration (" + index + "/" + total + ")");
        long startTime = System.currentTimeMillis();
        migrationTask.runMigration(this.processingState);
        long duration = System.currentTimeMillis() - startTime;
        LOGGER.debug(migrationTask.getIdentifier() + " migration completed in " + duration + " ms.");
        LOGGER.debug("Finished " + migrationTask.getIdentifier() + " migration (" + index + "/" + total + ")");
    }
}

