/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.backpressure;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;

public final class AppendBackpressureMetrics {
    private static final Counter TOTAL_DEFERRED_APPEND_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("deferred_append_count_total")).help("Number of deferred appends due to backpressure")).labelNames("partition")).register();
    private static final Counter TOTAL_APPEND_TRY_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("try_to_append_total")).help("Number of tries to append")).labelNames("partition")).register();
    private static final Gauge CURRENT_INFLIGHT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("backpressure_inflight_append_count")).help("Current number of append inflight")).labelNames("partition")).register();
    private static final Gauge CURRENT_LIMIT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("backpressure_append_limit")).help("Current limit for number of inflight appends")).labelNames("partition")).register();
    private final int partitionId;

    public AppendBackpressureMetrics(int partitionId) {
        this.partitionId = partitionId;
    }

    public void deferred() {
        ((Counter.Child)TOTAL_DEFERRED_APPEND_COUNT.labels(String.valueOf(this.partitionId))).inc();
    }

    public void newEntryToAppend() {
        ((Counter.Child)TOTAL_APPEND_TRY_COUNT.labels(String.valueOf(this.partitionId))).inc();
    }

    public void incInflight() {
        ((Gauge.Child)CURRENT_INFLIGHT.labels(String.valueOf(this.partitionId))).inc();
    }

    public void decInflight() {
        ((Gauge.Child)CURRENT_INFLIGHT.labels(String.valueOf(this.partitionId))).dec();
    }

    public void setNewLimit(int newLimit) {
        ((Gauge.Child)CURRENT_LIMIT.labels(String.valueOf(this.partitionId))).set(newLimit);
    }

    public void setInflight(int count) {
        ((Gauge.Child)CURRENT_INFLIGHT.labels(String.valueOf(this.partitionId))).set(0.0);
    }
}

