/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.backpressure;

import com.netflix.concurrency.limits.limit.AbstractLimit;
import com.netflix.concurrency.limits.limit.VegasLimit;
import io.camunda.zeebe.logstreams.impl.backpressure.AlgorithmCfg;
import io.camunda.zeebe.util.Environment;

public final class AppenderVegasCfg
implements AlgorithmCfg {
    private int initialLimit = 1024;
    private int maxConcurrency = 32768;
    private double alphaLimit = 0.7;
    private double betaLimit = 0.95;

    @Override
    public void applyEnvironment(Environment environment2) {
        environment2.getInt("ZEEBE_BP_APPENDER_VEGAS_INIT_LIMIT").ifPresent(this::setInitialLimit);
        environment2.getInt("ZEEBE_BP_APPENDER_VEGAS_MAX_CONCURRENCY").ifPresent(this::setMaxConcurrency);
        environment2.getDouble("ZEEBE_BP_APPENDER_VEGAS_ALPHA_LIMIT").ifPresent(this::setAlphaLimit);
        environment2.getDouble("ZEEBE_BP_APPENDER_VEGAS_BETA_LIMIT").ifPresent(this::setBetaLimit);
    }

    public int getInitialLimit() {
        return this.initialLimit;
    }

    public AppenderVegasCfg setInitialLimit(int initialLimit) {
        this.initialLimit = initialLimit;
        return this;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public AppenderVegasCfg setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    public double getAlphaLimit() {
        return this.alphaLimit;
    }

    public AppenderVegasCfg setAlphaLimit(double alphaLimit) {
        this.alphaLimit = alphaLimit;
        return this;
    }

    public double getBetaLimit() {
        return this.betaLimit;
    }

    public AppenderVegasCfg setBetaLimit(double betaLimit) {
        this.betaLimit = betaLimit;
        return this;
    }

    @Override
    public AbstractLimit get() {
        return VegasLimit.newBuilder().alpha(limit -> Math.max(3, (int)((double)limit.intValue() * this.alphaLimit))).beta(limit -> Math.max(6, (int)((double)limit.intValue() * this.betaLimit))).initialLimit(this.initialLimit).maxConcurrency(this.maxConcurrency).increase(limit -> limit + Math.log(limit)).decrease(limit -> limit - Math.log(limit)).build();
    }

    public String toString() {
        return "AppenderVegasCfg{initialLimit=" + this.initialLimit + ", maxConcurrency=" + this.maxConcurrency + ", alphaLimit=" + this.alphaLimit + ", betaLimit=" + this.betaLimit + "}";
    }
}

