/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

final class AppenderMetrics {
    private static final Gauge LAST_COMMITTED_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("log_appender_last_committed_position")).help("The last committed position.")).labelNames("partition")).register();
    private static final Gauge LAST_APPENDED_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("log_appender_last_appended_position")).help("The last appended position by the appender.")).labelNames("partition")).register();
    private static final Histogram WRITE_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("log_appender_append_latency")).help("Latency to append an event to the log in seconds")).labelNames("partition")).register();
    private static final Histogram COMMIT_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("log_appender_commit_latency")).help("Latency to commit an event to the log in seconds")).labelNames("partition")).register();
    private final String partitionLabel;

    AppenderMetrics(String partitionLabel) {
        this.partitionLabel = partitionLabel;
    }

    void setLastCommittedPosition(long position) {
        ((Gauge.Child)LAST_COMMITTED_POSITION.labels(this.partitionLabel)).set(position);
    }

    void setLastAppendedPosition(long position) {
        ((Gauge.Child)LAST_APPENDED_POSITION.labels(this.partitionLabel)).set(position);
    }

    Histogram.Timer startAppendLatencyTimer() {
        return ((Histogram.Child)WRITE_LATENCY.labels(this.partitionLabel)).startTimer();
    }

    Histogram.Timer startCommitLatencyTimer() {
        return ((Histogram.Child)COMMIT_LATENCY.labels(this.partitionLabel)).startTimer();
    }
}

