/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.logstreams.impl.log.LoggedEventImpl;
import io.camunda.zeebe.logstreams.log.LogStreamBatchReader;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.IntArrayList;

public class LogStreamBatchReaderImpl
implements LogStreamBatchReader {
    private static final Consumer<LoggedEvent> NOOP = event -> {};
    private final LogStreamBatchImpl batch = new LogStreamBatchImpl();
    private final MutableDirectBuffer eventBuffer = new ExpandableArrayBuffer();
    private final IntArrayList bufferOffsets = new IntArrayList();
    private final LogStreamReader logStreamReader;

    public LogStreamBatchReaderImpl(LogStreamReader logStreamReader) {
        this.logStreamReader = logStreamReader;
    }

    @Override
    public boolean seekToNextBatch(long position) {
        if (position < 0L) {
            this.logStreamReader.seekToFirstEvent();
            return true;
        }
        boolean found = this.logStreamReader.seek(position);
        if (found) {
            LogStreamBatchReader.Batch batch = this.next();
            batch.forEachRemaining(NOOP);
        }
        return found;
    }

    @Override
    public boolean hasNext() {
        return this.logStreamReader.hasNext();
    }

    @Override
    public LogStreamBatchReader.Batch next() {
        long sourceEventPosition;
        if (!this.logStreamReader.hasNext()) {
            throw new NoSuchElementException();
        }
        this.bufferOffsets.clear();
        int bufferOffset = 0;
        do {
            LoggedEvent event = (LoggedEvent)this.logStreamReader.next();
            sourceEventPosition = event.getSourceEventPosition();
            event.write(this.eventBuffer, bufferOffset);
            this.bufferOffsets.addInt(bufferOffset);
            bufferOffset += event.getLength();
        } while (this.logStreamReader.hasNext() && sourceEventPosition > 0L && sourceEventPosition == this.logStreamReader.peekNext().getSourceEventPosition());
        this.batch.wrap(this.eventBuffer, this.bufferOffsets);
        return this.batch;
    }

    @Override
    public void close() {
        this.logStreamReader.close();
        this.bufferOffsets.clear();
    }

    static class LogStreamBatchImpl
    implements LogStreamBatchReader.Batch {
        private final LoggedEventImpl event = new LoggedEventImpl();
        private DirectBuffer buffer;
        private IntArrayList offsets;
        private int currentIndex = 0;

        LogStreamBatchImpl() {
        }

        private void wrap(DirectBuffer buffer, IntArrayList offsets) {
            this.buffer = buffer;
            this.offsets = offsets;
            this.head();
        }

        @Override
        public void head() {
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.offsets.size();
        }

        @Override
        public LoggedEvent next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Integer offset = this.offsets.get(this.currentIndex);
            this.event.wrap(this.buffer, offset);
            ++this.currentIndex;
            return this.event;
        }
    }
}

