/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.dispatcher.ClaimedFragment;
import io.camunda.zeebe.dispatcher.Dispatcher;
import io.camunda.zeebe.logstreams.impl.log.LogEntryDescriptor;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.camunda.zeebe.util.buffer.DirectBufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;

final class LogStreamWriterImpl
implements LogStreamRecordWriter {
    private final DirectBufferWriter metadataWriterInstance = new DirectBufferWriter();
    private final DirectBufferWriter bufferWriterInstance = new DirectBufferWriter();
    private final ClaimedFragment claimedFragment = new ClaimedFragment();
    private final Dispatcher logWriteBuffer;
    private final int partitionId;
    private boolean skipProcessing;
    private long key;
    private long sourceRecordPosition = -1L;
    private BufferWriter metadataWriter;
    private BufferWriter valueWriter;

    LogStreamWriterImpl(int partitionId, Dispatcher logWriteBuffer) {
        this.logWriteBuffer = logWriteBuffer;
        this.partitionId = partitionId;
        this.reset();
    }

    @Override
    public LogStreamRecordWriter skipProcessing() {
        this.skipProcessing = true;
        return this;
    }

    @Override
    public LogStreamRecordWriter keyNull() {
        return this.key(-1L);
    }

    @Override
    public LogStreamRecordWriter key(long key) {
        this.key = key;
        return this;
    }

    @Override
    public LogStreamRecordWriter sourceRecordPosition(long position) {
        this.sourceRecordPosition = position;
        return this;
    }

    @Override
    public LogStreamRecordWriter metadata(DirectBuffer buffer, int offset, int length) {
        this.metadataWriterInstance.wrap(buffer, offset, length);
        return this;
    }

    @Override
    public LogStreamRecordWriter metadata(DirectBuffer buffer) {
        return this.metadata(buffer, 0, buffer.capacity());
    }

    @Override
    public LogStreamRecordWriter metadataWriter(BufferWriter writer) {
        this.metadataWriter = writer;
        return this;
    }

    @Override
    public LogStreamRecordWriter value(DirectBuffer value, int valueOffset, int valueLength) {
        return this.valueWriter(this.bufferWriterInstance.wrap(value, valueOffset, valueLength));
    }

    @Override
    public LogStreamRecordWriter value(DirectBuffer value) {
        return this.value(value, 0, value.capacity());
    }

    @Override
    public LogStreamRecordWriter valueWriter(BufferWriter writer) {
        this.valueWriter = writer;
        return this;
    }

    @Override
    public void reset() {
        this.skipProcessing = false;
        this.key = -1L;
        this.metadataWriter = this.metadataWriterInstance;
        this.valueWriter = null;
        this.sourceRecordPosition = -1L;
        this.bufferWriterInstance.reset();
        this.metadataWriterInstance.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long tryWrite() {
        int metadataLength;
        if (this.valueWriter == null) {
            return 0L;
        }
        long result = -1L;
        int valueLength = this.valueWriter.getLength();
        long claimedPosition = this.claimLogEntry(valueLength, metadataLength = this.metadataWriter.getLength());
        if (claimedPosition >= 0L) {
            try {
                MutableDirectBuffer writeBuffer = this.claimedFragment.getBuffer();
                int bufferOffset = this.claimedFragment.getOffset();
                LogEntryDescriptor.setPosition(writeBuffer, bufferOffset, claimedPosition);
                if (this.skipProcessing) {
                    LogEntryDescriptor.skipProcessing(writeBuffer, bufferOffset);
                }
                LogEntryDescriptor.setSourceEventPosition(writeBuffer, bufferOffset, this.sourceRecordPosition);
                LogEntryDescriptor.setKey(writeBuffer, bufferOffset, this.key);
                LogEntryDescriptor.setTimestamp(writeBuffer, bufferOffset, ActorClock.currentTimeMillis());
                LogEntryDescriptor.setMetadataLength(writeBuffer, bufferOffset, (short)metadataLength);
                if (metadataLength > 0) {
                    this.metadataWriter.write(writeBuffer, LogEntryDescriptor.metadataOffset(bufferOffset));
                }
                this.valueWriter.write(writeBuffer, LogEntryDescriptor.valueOffset(bufferOffset, metadataLength));
                result = claimedPosition;
                this.claimedFragment.commit();
            }
            catch (Exception e) {
                this.claimedFragment.abort();
                LangUtil.rethrowUnchecked(e);
            }
            finally {
                this.reset();
            }
        }
        return result;
    }

    private long claimLogEntry(int valueLength, int metadataLength) {
        long claimedPosition;
        int framedLength = valueLength + LogEntryDescriptor.headerLength(metadataLength);
        while ((claimedPosition = this.logWriteBuffer.claimSingleFragment(this.claimedFragment, framedLength, this.partitionId)) == -2L) {
        }
        return claimedPosition;
    }
}

