/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.util.ModelUtil;
import java.util.Collection;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class ProcessValidator
implements ModelElementValidator<Process> {
    @Override
    public Class<Process> getElementType() {
        return Process.class;
    }

    @Override
    public void validate(Process element, ValidationResultCollector validationResultCollector) {
        Collection<StartEvent> topLevelStartEvents = element.getChildElementsByType(StartEvent.class);
        if (topLevelStartEvents.isEmpty()) {
            validationResultCollector.addError(0, "Must have at least one start event");
        } else if (topLevelStartEvents.stream().filter(this::isNoneEvent).count() > 1L) {
            validationResultCollector.addError(0, "Multiple none start events are not allowed");
        }
        ModelUtil.verifyNoDuplicatedEventSubprocesses(element, error2 -> validationResultCollector.addError(0, (String)error2));
    }

    private boolean isNoneEvent(StartEvent startEvent) {
        return startEvent.getEventDefinitions().isEmpty();
    }
}

