/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.msgpack.value;

import io.camunda.zeebe.msgpack.spec.MsgPackFormat;
import io.camunda.zeebe.msgpack.spec.MsgPackHelper;
import io.camunda.zeebe.msgpack.spec.MsgPackType;
import io.camunda.zeebe.msgpack.value.BinaryValue;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class DocumentValue
extends BinaryValue {
    public static final DirectBuffer EMPTY_DOCUMENT = new UnsafeBuffer(MsgPackHelper.EMTPY_OBJECT);

    public DocumentValue() {
    }

    public DocumentValue(DirectBuffer initialValue, int offset, int length) {
        super(initialValue, offset, length);
    }

    @Override
    public void wrap(DirectBuffer buff, int offset, int length) {
        byte firstByte;
        MsgPackFormat format;
        boolean isValid;
        boolean documentIsNil;
        boolean bl = documentIsNil = length == 0 || length == 1 && buff.getByte(offset) == -64;
        if (documentIsNil) {
            buff = EMPTY_DOCUMENT;
            offset = 0;
            length = EMPTY_DOCUMENT.capacity();
        }
        boolean bl2 = isValid = (format = MsgPackFormat.valueOf(firstByte = buff.getByte(offset))).getType() == MsgPackType.MAP;
        if (!isValid) {
            throw new IllegalArgumentException(String.format("Expected document to be a root level object, but was '%s'", format.getType().name()));
        }
        super.wrap(buff, offset, length);
    }
}

