/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.Engine;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.processing.EngineProcessors;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionCommandSender;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.appliers.EventAppliers;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.engine.CommandSender;
import io.camunda.zeebe.process.test.engine.CommandWriter;
import io.camunda.zeebe.process.test.engine.EngineStateMonitor;
import io.camunda.zeebe.process.test.engine.GatewayRequestStore;
import io.camunda.zeebe.process.test.engine.GrpcResponseWriter;
import io.camunda.zeebe.process.test.engine.GrpcToLogStreamGateway;
import io.camunda.zeebe.process.test.engine.InMemoryEngine;
import io.camunda.zeebe.process.test.engine.InMemoryLogStorage;
import io.camunda.zeebe.process.test.engine.RecordStreamSourceImpl;
import io.camunda.zeebe.process.test.engine.db.InMemoryDbFactory;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.clock.ControlledActorClock;
import io.camunda.zeebe.streamprocessor.StreamProcessor;
import io.camunda.zeebe.util.FeatureFlags;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class EngineFactory {
    public static ZeebeTestEngine create() {
        return EngineFactory.create(EngineFactory.findFreePort());
    }

    private static int findFreePort() {
        int freePort;
        try (ServerSocket serverSocket = new ServerSocket(0);){
            freePort = serverSocket.getLocalPort();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return freePort;
    }

    public static ZeebeTestEngine create(int port) {
        boolean partitionId = true;
        boolean partitionCount = true;
        ControlledActorClock clock = EngineFactory.createActorClock();
        ActorScheduler scheduler = EngineFactory.createAndStartActorScheduler(clock);
        InMemoryLogStorage logStorage = new InMemoryLogStorage();
        LogStream logStream = EngineFactory.createLogStream(logStorage, scheduler, 1);
        CommandWriter commandWriter = new CommandWriter(logStream.newLogStreamRecordWriter().join());
        CommandSender commandSender = new CommandSender(commandWriter);
        GatewayRequestStore gatewayRequestStore = new GatewayRequestStore();
        GrpcToLogStreamGateway gateway = new GrpcToLogStreamGateway(commandWriter, 1, 1, port, gatewayRequestStore);
        Server grpcServer = ((ServerBuilder)ServerBuilder.forPort(port).addService(gateway)).build();
        GrpcResponseWriter grpcResponseWriter = new GrpcResponseWriter(gateway, gatewayRequestStore);
        ZeebeDb<ZbColumnFamilies> zeebeDb = EngineFactory.createDatabase();
        StreamProcessor streamProcessor = EngineFactory.createStreamProcessor(logStream, zeebeDb, scheduler, grpcResponseWriter, 1, commandSender);
        EngineStateMonitor engineStateMonitor = new EngineStateMonitor(logStorage, streamProcessor);
        LogStreamReader reader = logStream.newLogStreamReader().join();
        RecordStreamSourceImpl recordStream = new RecordStreamSourceImpl(reader, 1);
        return new InMemoryEngine(grpcServer, streamProcessor, gateway, zeebeDb, logStream, scheduler, recordStream, clock, engineStateMonitor);
    }

    private static ControlledActorClock createActorClock() {
        return new ControlledActorClock();
    }

    private static ActorScheduler createAndStartActorScheduler(ActorClock clock) {
        ActorScheduler scheduler = ActorScheduler.newActorScheduler().setActorClock(clock).build();
        scheduler.start();
        return scheduler;
    }

    private static LogStream createLogStream(LogStorage logStorage, ActorSchedulingService scheduler, int partitionId) {
        LogStreamBuilder builder = LogStream.builder().withPartitionId(partitionId).withLogStorage(logStorage).withActorSchedulingService(scheduler);
        CompletableFuture theFuture = new CompletableFuture();
        scheduler.submitActor(Actor.wrap(control -> builder.buildAsync().onComplete((logStream, failure) -> {
            if (failure != null) {
                theFuture.completeExceptionally((Throwable)failure);
            } else {
                theFuture.complete(logStream);
            }
        })));
        return (LogStream)theFuture.join();
    }

    private static ZeebeDb<ZbColumnFamilies> createDatabase() {
        InMemoryDbFactory factory = new InMemoryDbFactory();
        return factory.createDb();
    }

    private static StreamProcessor createStreamProcessor(LogStream logStream, ZeebeDb<ZbColumnFamilies> database, ActorSchedulingService scheduler, GrpcResponseWriter grpcResponseWriter, int partitionCount, CommandSender commandSender) {
        return StreamProcessor.builder().logStream(logStream).zeebeDb(database).commandResponseWriter(grpcResponseWriter).eventApplierFactory(EventAppliers::new).partitionCommandSender(commandSender).recordProcessors(List.of(new Engine(context -> EngineProcessors.createEngineProcessors(context, partitionCount, new SubscriptionCommandSender(context.getPartitionId(), commandSender), new DeploymentDistributionCommandSender(context.getPartitionId(), commandSender), jobType -> {}, FeatureFlags.createDefault()), new EngineConfiguration()))).actorSchedulingService(scheduler).build();
    }
}

