/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine;

import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.msgpack.value.ObjectValue;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.process.test.engine.CommandWriter;
import io.camunda.zeebe.process.test.engine.GatewayRequestStore;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationStartInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationActivateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationTerminateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationVariableInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import io.camunda.zeebe.util.VersionUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.grpc.stub.StreamObserver;

class GrpcToLogStreamGateway
extends GatewayGrpc.GatewayImplBase {
    private final CommandWriter writer;
    private final int partitionId;
    private final int partitionCount;
    private final int port;
    private final GatewayRequestStore gatewayRequestStore;

    public GrpcToLogStreamGateway(CommandWriter writer, int partitionId, int partitionCount, int port, GatewayRequestStore gatewayRequestStore) {
        this.writer = writer;
        this.partitionId = partitionId;
        this.partitionCount = partitionCount;
        this.port = port;
        this.gatewayRequestStore = gatewayRequestStore;
    }

    @Override
    public void activateJobs(GatewayOuterClass.ActivateJobsRequest request, StreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId).valueType(ValueType.JOB_BATCH).intent(JobBatchIntent.ACTIVATE);
        JobBatchRecord jobBatchRecord = new JobBatchRecord();
        jobBatchRecord.setType(request.getType());
        jobBatchRecord.setWorker(request.getWorker());
        jobBatchRecord.setTimeout(request.getTimeout());
        jobBatchRecord.setMaxJobsToActivate(request.getMaxJobsToActivate());
        this.writer.writeCommandWithoutKey(jobBatchRecord, recordMetadata);
    }

    @Override
    public void cancelProcessInstance(GatewayOuterClass.CancelProcessInstanceRequest request, StreamObserver<GatewayOuterClass.CancelProcessInstanceResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId).valueType(ValueType.PROCESS_INSTANCE).intent(ProcessInstanceIntent.CANCEL);
        ProcessInstanceRecord processInstanceRecord = new ProcessInstanceRecord();
        processInstanceRecord.setProcessInstanceKey(request.getProcessInstanceKey());
        this.writer.writeCommandWithKey(request.getProcessInstanceKey(), processInstanceRecord, recordMetadata);
    }

    @Override
    public void completeJob(GatewayOuterClass.CompleteJobRequest request, StreamObserver<GatewayOuterClass.CompleteJobResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId).valueType(ValueType.JOB).intent(JobIntent.COMPLETE);
        JobRecord jobRecord = new JobRecord();
        String variables = request.getVariables();
        if (!variables.isEmpty()) {
            jobRecord.setVariables(BufferUtil.wrapArray(MsgPackConverter.convertToMsgPack(variables)));
        }
        this.writer.writeCommandWithKey(request.getJobKey(), jobRecord, recordMetadata);
    }

    @Override
    public void createProcessInstance(GatewayOuterClass.CreateProcessInstanceRequest request, StreamObserver<GatewayOuterClass.CreateProcessInstanceResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId).valueType(ValueType.PROCESS_INSTANCE_CREATION).intent(ProcessInstanceCreationIntent.CREATE);
        ProcessInstanceCreationRecord processInstanceCreationRecord = this.createProcessInstanceCreationRecord(request);
        this.writer.writeCommandWithoutKey(processInstanceCreationRecord, recordMetadata);
    }

    @Override
    public void createProcessInstanceWithResult(GatewayOuterClass.CreateProcessInstanceWithResultRequest request, StreamObserver<GatewayOuterClass.CreateProcessInstanceWithResultResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId).valueType(ValueType.PROCESS_INSTANCE_CREATION).intent(ProcessInstanceCreationIntent.CREATE_WITH_AWAITING_RESULT);
        ProcessInstanceCreationRecord processInstanceCreationRecord = this.createProcessInstanceCreationRecord(request.getRequest());
        processInstanceCreationRecord.setFetchVariables(request.getFetchVariablesList());
        this.writer.writeCommandWithoutKey(processInstanceCreationRecord, recordMetadata);
    }

    @Override
    public void deployProcess(GatewayOuterClass.DeployProcessRequest request, StreamObserver<GatewayOuterClass.DeployProcessResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId).valueType(ValueType.DEPLOYMENT).intent(DeploymentIntent.CREATE);
        DeploymentRecord deploymentRecord = new DeploymentRecord();
        ValueArray<DeploymentResource> resources = deploymentRecord.resources();
        request.getProcessesList().forEach(processRequestObject -> ((DeploymentResource)resources.add()).setResourceName(processRequestObject.getName()).setResource(processRequestObject.getDefinition().toByteArray()));
        this.writer.writeCommandWithoutKey(deploymentRecord, recordMetadata);
    }

    @Override
    public void deployResource(GatewayOuterClass.DeployResourceRequest request, StreamObserver<GatewayOuterClass.DeployResourceResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId).valueType(ValueType.DEPLOYMENT).intent(DeploymentIntent.CREATE);
        DeploymentRecord deploymentRecord = new DeploymentRecord();
        ValueArray<DeploymentResource> resources = deploymentRecord.resources();
        request.getResourcesList().forEach(resource -> ((DeploymentResource)resources.add()).setResourceName(resource.getName()).setResource(resource.getContent().toByteArray()));
        this.writer.writeCommandWithoutKey(deploymentRecord, recordMetadata);
    }

    @Override
    public void failJob(GatewayOuterClass.FailJobRequest request, StreamObserver<GatewayOuterClass.FailJobResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId).valueType(ValueType.JOB).intent(JobIntent.FAIL);
        JobRecord jobRecord = new JobRecord();
        jobRecord.setRetries(request.getRetries());
        jobRecord.setErrorMessage(request.getErrorMessage());
        this.writer.writeCommandWithKey(request.getJobKey(), jobRecord, recordMetadata);
    }

    @Override
    public void throwError(GatewayOuterClass.ThrowErrorRequest request, StreamObserver<GatewayOuterClass.ThrowErrorResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId).valueType(ValueType.JOB).intent(JobIntent.THROW_ERROR);
        JobRecord jobRecord = new JobRecord();
        jobRecord.setErrorCode(BufferUtil.wrapString(request.getErrorCode()));
        jobRecord.setErrorMessage(request.getErrorMessage());
        this.writer.writeCommandWithKey(request.getJobKey(), jobRecord, recordMetadata);
    }

    @Override
    public void publishMessage(GatewayOuterClass.PublishMessageRequest request, StreamObserver<GatewayOuterClass.PublishMessageResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId).valueType(ValueType.MESSAGE).intent(MessageIntent.PUBLISH);
        MessageRecord messageRecord = new MessageRecord();
        messageRecord.setCorrelationKey(request.getCorrelationKey());
        messageRecord.setMessageId(request.getMessageId());
        messageRecord.setName(request.getName());
        messageRecord.setTimeToLive(request.getTimeToLive());
        String variables = request.getVariables();
        if (!variables.isEmpty()) {
            messageRecord.setVariables(BufferUtil.wrapArray(MsgPackConverter.convertToMsgPack(variables)));
        }
        this.writer.writeCommandWithoutKey(messageRecord, recordMetadata);
    }

    @Override
    public void resolveIncident(GatewayOuterClass.ResolveIncidentRequest request, StreamObserver<GatewayOuterClass.ResolveIncidentResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId).valueType(ValueType.INCIDENT).intent(IncidentIntent.RESOLVE);
        IncidentRecord incidentRecord = new IncidentRecord();
        this.writer.writeCommandWithKey(request.getIncidentKey(), incidentRecord, recordMetadata);
    }

    @Override
    public void setVariables(GatewayOuterClass.SetVariablesRequest request, StreamObserver<GatewayOuterClass.SetVariablesResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId).valueType(ValueType.VARIABLE_DOCUMENT).intent(VariableDocumentIntent.UPDATE);
        VariableDocumentRecord variableDocumentRecord = new VariableDocumentRecord();
        String variables = request.getVariables();
        if (!variables.isEmpty()) {
            variableDocumentRecord.setVariables(BufferUtil.wrapArray(MsgPackConverter.convertToMsgPack(variables)));
        }
        variableDocumentRecord.setScopeKey(request.getElementInstanceKey());
        variableDocumentRecord.setUpdateSemantics(request.getLocal() ? VariableDocumentUpdateSemantic.LOCAL : VariableDocumentUpdateSemantic.PROPAGATE);
        this.writer.writeCommandWithoutKey(variableDocumentRecord, recordMetadata);
    }

    @Override
    public void topology(GatewayOuterClass.TopologyRequest request, StreamObserver<GatewayOuterClass.TopologyResponse> responseObserver) {
        GatewayOuterClass.Partition partition = GatewayOuterClass.Partition.newBuilder().setHealth(GatewayOuterClass.Partition.PartitionBrokerHealth.HEALTHY).setRole(GatewayOuterClass.Partition.PartitionBrokerRole.LEADER).setPartitionId(this.partitionId).build();
        GatewayOuterClass.BrokerInfo brokerInfo = GatewayOuterClass.BrokerInfo.newBuilder().addPartitions(partition).setHost("0.0.0.0").setPort(this.port).setVersion(VersionUtil.getVersion()).build();
        GatewayOuterClass.TopologyResponse topologyResponse = GatewayOuterClass.TopologyResponse.newBuilder().addBrokers(brokerInfo).setClusterSize(1).setPartitionsCount(this.partitionCount).setReplicationFactor(1).setGatewayVersion(VersionUtil.getVersion()).build();
        responseObserver.onNext(topologyResponse);
        responseObserver.onCompleted();
    }

    @Override
    public void updateJobRetries(GatewayOuterClass.UpdateJobRetriesRequest request, StreamObserver<GatewayOuterClass.UpdateJobRetriesResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId).valueType(ValueType.JOB).intent(JobIntent.UPDATE_RETRIES);
        JobRecord jobRecord = new JobRecord();
        jobRecord.setRetries(request.getRetries());
        this.writer.writeCommandWithKey(request.getJobKey(), jobRecord, recordMetadata);
    }

    @Override
    public void modifyProcessInstance(GatewayOuterClass.ModifyProcessInstanceRequest request, StreamObserver<GatewayOuterClass.ModifyProcessInstanceResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId).valueType(ValueType.PROCESS_INSTANCE_MODIFICATION).intent(ProcessInstanceModificationIntent.MODIFY);
        ProcessInstanceModificationRecord record = this.createProcessInstanceModificationRecord(request);
        this.writer.writeCommandWithKey(request.getProcessInstanceKey(), record, recordMetadata);
    }

    private ProcessInstanceModificationRecord createProcessInstanceModificationRecord(GatewayOuterClass.ModifyProcessInstanceRequest request) {
        ObjectValue instruction;
        ProcessInstanceModificationRecord record = new ProcessInstanceModificationRecord();
        record.setProcessInstanceKey(request.getProcessInstanceKey());
        for (GatewayOuterClass.ModifyProcessInstanceRequest.ActivateInstruction activate : request.getActivateInstructionsList()) {
            instruction = new ProcessInstanceModificationActivateInstruction().setElementId(activate.getElementId()).setAncestorScopeKey(activate.getAncestorElementInstanceKey());
            for (GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction variable : activate.getVariableInstructionsList()) {
                ((ProcessInstanceModificationActivateInstruction)instruction).addVariableInstruction(new ProcessInstanceModificationVariableInstruction().setElementId(variable.getScopeId()).setVariables(BufferUtil.wrapArray(MsgPackConverter.convertToMsgPack(variable.getVariables()))));
            }
            record.addActivateInstruction((ProcessInstanceModificationActivateInstruction)instruction);
        }
        for (GatewayOuterClass.ModifyProcessInstanceRequest.TerminateInstruction terminate : request.getTerminateInstructionsList()) {
            instruction = new ProcessInstanceModificationTerminateInstruction().setElementInstanceKey(terminate.getElementInstanceKey());
            record.addTerminateInstruction((ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue)((Object)instruction));
        }
        return record;
    }

    private RecordMetadata prepareRecordMetadata() {
        return new RecordMetadata().recordType(RecordType.COMMAND).requestStreamId(this.partitionId);
    }

    private ProcessInstanceCreationRecord createProcessInstanceCreationRecord(GatewayOuterClass.CreateProcessInstanceRequest request) {
        ProcessInstanceCreationRecord processInstanceCreationRecord = new ProcessInstanceCreationRecord();
        processInstanceCreationRecord.setBpmnProcessId(request.getBpmnProcessId());
        processInstanceCreationRecord.setVersion(request.getVersion());
        processInstanceCreationRecord.setProcessDefinitionKey(request.getProcessDefinitionKey());
        request.getStartInstructionsList().stream().map(startInstruction -> new ProcessInstanceCreationStartInstruction().setElementId(startInstruction.getElementId())).forEach(processInstanceCreationRecord::addStartInstruction);
        String variables = request.getVariables();
        if (!variables.isEmpty()) {
            processInstanceCreationRecord.setVariables(BufferUtil.wrapArray(MsgPackConverter.convertToMsgPack(variables)));
        }
        return processInstanceCreationRecord;
    }

    public String getAddress() {
        return "0.0.0.0:" + this.port;
    }
}

