/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine.db;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionOperation;
import io.camunda.zeebe.db.ZeebeDbTransaction;
import io.camunda.zeebe.process.test.engine.db.Bytes;
import io.camunda.zeebe.process.test.engine.db.FullyQualifiedKey;
import io.camunda.zeebe.process.test.engine.db.InMemoryDbIterator;
import io.camunda.zeebe.process.test.engine.db.InMemoryDbState;
import java.util.HashSet;
import java.util.TreeMap;

final class InMemoryDbTransaction
implements ZeebeDbTransaction,
InMemoryDbState {
    private final TreeMap<Bytes, Bytes> database;
    private final TreeMap<Bytes, Bytes> transactionCache = new TreeMap();
    private final HashSet<Bytes> deletedKeys = new HashSet();
    private boolean inCurrentTransaction = false;

    InMemoryDbTransaction(TreeMap<Bytes, Bytes> database) {
        this.database = database;
    }

    void resetTransaction() {
        this.rollback();
        this.inCurrentTransaction = true;
    }

    public boolean isInCurrentTransaction() {
        return this.inCurrentTransaction;
    }

    @Override
    public void run(TransactionOperation operations) throws Exception {
        operations.run();
    }

    @Override
    public void commit() {
        this.inCurrentTransaction = false;
        this.database.putAll(this.transactionCache);
        this.deletedKeys.forEach(this.database::remove);
        this.deletedKeys.clear();
        this.transactionCache.clear();
    }

    @Override
    public void rollback() {
        this.inCurrentTransaction = false;
        this.deletedKeys.clear();
        this.transactionCache.clear();
    }

    @Override
    public void put(FullyQualifiedKey fullyQualifiedKey, DbValue value) {
        this.deletedKeys.remove(fullyQualifiedKey.getKeyBytes());
        this.transactionCache.put(fullyQualifiedKey.getKeyBytes(), Bytes.fromDbValue(value));
    }

    @Override
    public byte[] get(FullyQualifiedKey fullyQualifiedKey) {
        Bytes key = fullyQualifiedKey.getKeyBytes();
        Bytes valueInCache = this.transactionCache.get(key);
        if (valueInCache != null) {
            return valueInCache.toBytes();
        }
        Bytes valueInDatabase = this.database.get(key);
        if (valueInDatabase != null) {
            return valueInDatabase.toBytes();
        }
        return null;
    }

    @Override
    public void delete(FullyQualifiedKey fullyQualifiedKey) {
        Bytes keyBytes = fullyQualifiedKey.getKeyBytes();
        this.transactionCache.remove(keyBytes);
        this.deletedKeys.add(keyBytes);
    }

    @Override
    public InMemoryDbIterator newIterator() {
        TreeMap<Bytes, Bytes> snapshot = new TreeMap<Bytes, Bytes>();
        snapshot.putAll(this.database);
        snapshot.putAll(this.transactionCache);
        return new InMemoryDbIterator(snapshot);
    }

    @Override
    public boolean contains(FullyQualifiedKey fullyQualifiedKey) {
        Bytes keyBytes = fullyQualifiedKey.getKeyBytes();
        return this.transactionCache.containsKey(keyBytes) || this.database.containsKey(keyBytes);
    }
}

