/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine.db;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.TransactionOperation;
import io.camunda.zeebe.db.ZeebeDbInconsistentException;
import io.camunda.zeebe.db.ZeebeDbTransaction;
import io.camunda.zeebe.process.test.engine.db.Bytes;
import io.camunda.zeebe.process.test.engine.db.InMemoryDbTransaction;
import java.util.TreeMap;

class InMemoryDbTransactionContext
implements TransactionContext {
    private final InMemoryDbTransaction transaction;

    public InMemoryDbTransactionContext(TreeMap<Bytes, Bytes> database) {
        this.transaction = new InMemoryDbTransaction(database);
    }

    @Override
    public void runInTransaction(TransactionOperation operations) {
        try {
            if (this.transaction.isInCurrentTransaction()) {
                operations.run();
            } else {
                this.runInNewTransaction(operations);
            }
        }
        catch (ZeebeDbInconsistentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error occurred during zeebe db transaction operation.", e);
        }
    }

    @Override
    public ZeebeDbTransaction getCurrentTransaction() {
        if (!this.transaction.isInCurrentTransaction()) {
            this.transaction.resetTransaction();
        }
        return this.transaction;
    }

    private void runInNewTransaction(TransactionOperation operations) throws Exception {
        try {
            this.transaction.resetTransaction();
            operations.run();
            this.transaction.commit();
        }
        catch (Exception e) {
            this.transaction.rollback();
            throw e;
        }
    }
}

