/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.decision;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.spec.MsgPackHelper;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.decision.EvaluatedDecisionRecord;
import io.camunda.zeebe.protocol.record.value.DecisionEvaluationRecordValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedDecisionValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.List;
import org.agrona.DirectBuffer;

public final class DecisionEvaluationRecord
extends UnifiedRecordValue
implements DecisionEvaluationRecordValue {
    private static final DirectBuffer NIL_DECISION_OUTPUT = BufferUtil.wrapArray(MsgPackHelper.NIL);
    private final LongProperty decisionKeyProp = new LongProperty("decisionKey");
    private final StringProperty decisionIdProp = new StringProperty("decisionId");
    private final StringProperty decisionNameProp = new StringProperty("decisionName");
    private final IntegerProperty decisionVersionProp = new IntegerProperty("decisionVersion");
    private final StringProperty decisionRequirementsIdProp = new StringProperty("decisionRequirementsId");
    private final LongProperty decisionRequirementsKeyProp = new LongProperty("decisionRequirementsKey");
    private final BinaryProperty decisionOutputProp = new BinaryProperty("decisionOutput", NIL_DECISION_OUTPUT);
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId");
    private final LongProperty processDefinitionKeyProp = new LongProperty("processDefinitionKey");
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey");
    private final StringProperty elementIdProp = new StringProperty("elementId");
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey");
    private final ArrayProperty<EvaluatedDecisionRecord> evaluatedDecisionsProp = new ArrayProperty<EvaluatedDecisionRecord>("evaluatedDecisions", new EvaluatedDecisionRecord());
    private final StringProperty evaluationFailureMessageProp = new StringProperty("evaluationFailureMessage", "");
    private final StringProperty failedDecisionIdProp = new StringProperty("failedDecisionId", "");

    public DecisionEvaluationRecord() {
        this.declareProperty(this.decisionKeyProp).declareProperty(this.decisionIdProp).declareProperty(this.decisionNameProp).declareProperty(this.decisionVersionProp).declareProperty(this.decisionRequirementsIdProp).declareProperty(this.decisionRequirementsKeyProp).declareProperty(this.decisionOutputProp).declareProperty(this.bpmnProcessIdProp).declareProperty(this.processDefinitionKeyProp).declareProperty(this.processInstanceKeyProp).declareProperty(this.elementIdProp).declareProperty(this.elementInstanceKeyProp).declareProperty(this.evaluatedDecisionsProp).declareProperty(this.evaluationFailureMessageProp).declareProperty(this.failedDecisionIdProp);
    }

    @Override
    public long getDecisionKey() {
        return this.decisionKeyProp.getValue();
    }

    public DecisionEvaluationRecord setDecisionKey(long decisionKey) {
        this.decisionKeyProp.setValue(decisionKey);
        return this;
    }

    @Override
    public String getDecisionId() {
        return BufferUtil.bufferAsString(this.decisionIdProp.getValue());
    }

    public DecisionEvaluationRecord setDecisionId(String decisionId) {
        this.decisionIdProp.setValue(decisionId);
        return this;
    }

    public DecisionEvaluationRecord setDecisionId(DirectBuffer decisionId) {
        this.decisionIdProp.setValue(decisionId);
        return this;
    }

    @Override
    public String getDecisionName() {
        return BufferUtil.bufferAsString(this.decisionNameProp.getValue());
    }

    public DecisionEvaluationRecord setDecisionName(String decisionName) {
        this.decisionNameProp.setValue(decisionName);
        return this;
    }

    public DecisionEvaluationRecord setDecisionName(DirectBuffer decisionName) {
        this.decisionNameProp.setValue(decisionName);
        return this;
    }

    @Override
    public int getDecisionVersion() {
        return this.decisionVersionProp.getValue();
    }

    public DecisionEvaluationRecord setDecisionVersion(int decisionVersion) {
        this.decisionVersionProp.setValue(decisionVersion);
        return this;
    }

    @Override
    public String getDecisionRequirementsId() {
        return BufferUtil.bufferAsString(this.decisionRequirementsIdProp.getValue());
    }

    public DecisionEvaluationRecord setDecisionRequirementsId(String decisionRequirementsId) {
        this.decisionRequirementsIdProp.setValue(decisionRequirementsId);
        return this;
    }

    public DecisionEvaluationRecord setDecisionRequirementsId(DirectBuffer decisionRequirementsId) {
        this.decisionRequirementsIdProp.setValue(decisionRequirementsId);
        return this;
    }

    @Override
    public long getDecisionRequirementsKey() {
        return this.decisionRequirementsKeyProp.getValue();
    }

    public DecisionEvaluationRecord setDecisionRequirementsKey(long decisionRequirementsKey) {
        this.decisionRequirementsKeyProp.setValue(decisionRequirementsKey);
        return this;
    }

    @Override
    public String getDecisionOutput() {
        return MsgPackConverter.convertToJson(this.decisionOutputProp.getValue());
    }

    public DecisionEvaluationRecord setDecisionOutput(DirectBuffer decisionOutput) {
        this.decisionOutputProp.setValue(decisionOutput);
        return this;
    }

    @Override
    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString(this.bpmnProcessIdProp.getValue());
    }

    public DecisionEvaluationRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public DecisionEvaluationRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProp.getValue();
    }

    public DecisionEvaluationRecord setProcessDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKeyProp.setValue(processDefinitionKey);
        return this;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public DecisionEvaluationRecord setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKeyProp.setValue(processInstanceKey);
        return this;
    }

    @Override
    public String getElementId() {
        return BufferUtil.bufferAsString(this.elementIdProp.getValue());
    }

    public DecisionEvaluationRecord setElementId(String elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    public DecisionEvaluationRecord setElementId(DirectBuffer elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    @Override
    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    public DecisionEvaluationRecord setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKeyProp.setValue(elementInstanceKey);
        return this;
    }

    @Override
    public List<EvaluatedDecisionValue> getEvaluatedDecisions() {
        ArrayList<EvaluatedDecisionValue> evaluatedDecisions = new ArrayList<EvaluatedDecisionValue>();
        for (EvaluatedDecisionRecord evaluatedDecision : this.evaluatedDecisionsProp) {
            EvaluatedDecisionRecord copyRecord = new EvaluatedDecisionRecord();
            DirectBuffer copyBuffer = BufferUtil.createCopy(evaluatedDecision);
            copyRecord.wrap(copyBuffer);
            evaluatedDecisions.add(copyRecord);
        }
        return evaluatedDecisions;
    }

    @Override
    public String getEvaluationFailureMessage() {
        return BufferUtil.bufferAsString(this.evaluationFailureMessageProp.getValue());
    }

    @Override
    public String getFailedDecisionId() {
        return BufferUtil.bufferAsString(this.failedDecisionIdProp.getValue());
    }

    public DecisionEvaluationRecord setFailedDecisionId(String failedDecisionId) {
        this.failedDecisionIdProp.setValue(failedDecisionId);
        return this;
    }

    public DecisionEvaluationRecord setEvaluationFailureMessage(String evaluationFailureMessage) {
        this.evaluationFailureMessageProp.setValue(evaluationFailureMessage);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getEvaluationFailureMessageBuffer() {
        return this.evaluationFailureMessageProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getFailedDecisionIdBuffer() {
        return this.failedDecisionIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getDecisionOutputBuffer() {
        return this.decisionOutputProp.getValue();
    }

    @JsonIgnore
    public ValueArray<EvaluatedDecisionRecord> evaluatedDecisions() {
        return this.evaluatedDecisionsProp;
    }

    @JsonIgnore
    public DirectBuffer getDecisionRequirementsIdBuffer() {
        return this.decisionRequirementsIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getDecisionIdBuffer() {
        return this.decisionIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getDecisionNameBuffer() {
        return this.decisionNameProp.getValue();
    }
}

