/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.decision;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.decision.EvaluatedInputRecord;
import io.camunda.zeebe.protocol.impl.record.value.decision.MatchedRuleRecord;
import io.camunda.zeebe.protocol.record.value.EvaluatedDecisionValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedInputValue;
import io.camunda.zeebe.protocol.record.value.MatchedRuleValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.List;
import org.agrona.DirectBuffer;

public final class EvaluatedDecisionRecord
extends UnifiedRecordValue
implements EvaluatedDecisionValue {
    private final StringProperty decisionIdProp = new StringProperty("decisionId");
    private final StringProperty decisionNameProp = new StringProperty("decisionName");
    private final LongProperty decisionKeyProp = new LongProperty("decisionKey");
    private final IntegerProperty decisionVersionProp = new IntegerProperty("decisionVersion");
    private final StringProperty decisionTypeProp = new StringProperty("decisionType");
    private final BinaryProperty decisionOutputProp = new BinaryProperty("decisionOutput");
    private final ArrayProperty<EvaluatedInputRecord> evaluatedInputsProp = new ArrayProperty<EvaluatedInputRecord>("evaluatedInputs", new EvaluatedInputRecord());
    private final ArrayProperty<MatchedRuleRecord> matchedRulesProp = new ArrayProperty<MatchedRuleRecord>("matchedRules", new MatchedRuleRecord());

    public EvaluatedDecisionRecord() {
        this.declareProperty(this.decisionIdProp).declareProperty(this.decisionNameProp).declareProperty(this.decisionKeyProp).declareProperty(this.decisionVersionProp).declareProperty(this.decisionTypeProp).declareProperty(this.decisionOutputProp).declareProperty(this.evaluatedInputsProp).declareProperty(this.matchedRulesProp);
    }

    @Override
    public String getDecisionId() {
        return BufferUtil.bufferAsString(this.decisionIdProp.getValue());
    }

    public EvaluatedDecisionRecord setDecisionId(String decisionId) {
        this.decisionIdProp.setValue(decisionId);
        return this;
    }

    @Override
    public String getDecisionName() {
        return BufferUtil.bufferAsString(this.decisionNameProp.getValue());
    }

    public EvaluatedDecisionRecord setDecisionName(String decisionName) {
        this.decisionNameProp.setValue(decisionName);
        return this;
    }

    @Override
    public long getDecisionKey() {
        return this.decisionKeyProp.getValue();
    }

    public EvaluatedDecisionRecord setDecisionKey(long decisionKey) {
        this.decisionKeyProp.setValue(decisionKey);
        return this;
    }

    @Override
    public long getDecisionVersion() {
        return this.decisionVersionProp.getValue();
    }

    public EvaluatedDecisionRecord setDecisionVersion(int decisionVersion) {
        this.decisionVersionProp.setValue(decisionVersion);
        return this;
    }

    @Override
    public String getDecisionType() {
        return BufferUtil.bufferAsString(this.decisionTypeProp.getValue());
    }

    public EvaluatedDecisionRecord setDecisionType(String decisionType) {
        this.decisionTypeProp.setValue(decisionType);
        return this;
    }

    @Override
    public String getDecisionOutput() {
        return MsgPackConverter.convertToJson(this.decisionOutputProp.getValue());
    }

    public EvaluatedDecisionRecord setDecisionOutput(DirectBuffer decisionOutput) {
        this.decisionOutputProp.setValue(decisionOutput);
        return this;
    }

    @Override
    public List<EvaluatedInputValue> getEvaluatedInputs() {
        ArrayList<EvaluatedInputValue> evaluatedInputs = new ArrayList<EvaluatedInputValue>();
        for (EvaluatedInputRecord evaluatedInput : this.evaluatedInputsProp) {
            EvaluatedInputRecord copyRecord = new EvaluatedInputRecord();
            DirectBuffer copyBuffer = BufferUtil.createCopy(evaluatedInput);
            copyRecord.wrap(copyBuffer);
            evaluatedInputs.add(copyRecord);
        }
        return evaluatedInputs;
    }

    @Override
    public List<MatchedRuleValue> getMatchedRules() {
        ArrayList<MatchedRuleValue> matchedRules = new ArrayList<MatchedRuleValue>();
        for (MatchedRuleRecord matchedRule : this.matchedRulesProp) {
            MatchedRuleRecord copyRecord = new MatchedRuleRecord();
            DirectBuffer copyBuffer = BufferUtil.createCopy(matchedRule);
            copyRecord.wrap(copyBuffer);
            matchedRules.add(copyRecord);
        }
        return matchedRules;
    }

    @JsonIgnore
    public DirectBuffer getDecisionOutputBuffer() {
        return this.decisionOutputProp.getValue();
    }

    @JsonIgnore
    public ValueArray<MatchedRuleRecord> matchedRules() {
        return this.matchedRulesProp;
    }

    @JsonIgnore
    public ValueArray<EvaluatedInputRecord> evaluatedInputs() {
        return this.evaluatedInputsProp;
    }

    @JsonIgnore
    public DirectBuffer getDecisionIdBuffer() {
        return this.decisionIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getDecisionNameBuffer() {
        return this.decisionNameProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getDecisionTypeBuffer() {
        return this.decisionTypeProp.getValue();
    }
}

