/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.decision;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedOutputValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class EvaluatedOutputRecord
extends UnifiedRecordValue
implements EvaluatedOutputValue {
    private final StringProperty outputIdProp = new StringProperty("outputId");
    private final StringProperty outputNameProp = new StringProperty("outputName", "");
    private final BinaryProperty outputValueProp = new BinaryProperty("outputValue");

    public EvaluatedOutputRecord() {
        this.declareProperty(this.outputIdProp).declareProperty(this.outputNameProp).declareProperty(this.outputValueProp);
    }

    @Override
    public String getOutputId() {
        return BufferUtil.bufferAsString(this.outputIdProp.getValue());
    }

    public EvaluatedOutputRecord setOutputId(String outputId) {
        this.outputIdProp.setValue(outputId);
        return this;
    }

    @Override
    public String getOutputName() {
        return BufferUtil.bufferAsString(this.outputNameProp.getValue());
    }

    public EvaluatedOutputRecord setOutputName(String outputName) {
        this.outputNameProp.setValue(outputName);
        return this;
    }

    @Override
    public String getOutputValue() {
        return MsgPackConverter.convertToJson(this.outputValueProp.getValue());
    }

    public EvaluatedOutputRecord setOutputValue(DirectBuffer outputValue) {
        this.outputValueProp.setValue(outputValue);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getOutputValueBuffer() {
        return this.outputValueProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getOutputIdBuffer() {
        return this.outputIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getOutputNameBuffer() {
        return this.outputNameProp.getValue();
    }
}

