/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.deployment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class DeploymentResource
extends UnpackedObject
implements io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource {
    private final BinaryProperty resourceProp = new BinaryProperty("resource");
    private final StringProperty resourceNameProp = new StringProperty("resourceName", "resource");

    public DeploymentResource() {
        this.declareProperty(this.resourceNameProp).declareProperty(this.resourceProp);
    }

    @Override
    public byte[] getResource() {
        return BufferUtil.bufferAsArray(this.resourceProp.getValue());
    }

    @Override
    public String getResourceName() {
        return BufferUtil.bufferAsString(this.resourceNameProp.getValue());
    }

    public DeploymentResource setResourceName(String resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public DeploymentResource setResourceName(DirectBuffer resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public DeploymentResource setResource(byte[] resource) {
        return this.setResource(BufferUtil.wrapArray(resource));
    }

    public DeploymentResource setResource(DirectBuffer resource) {
        return this.setResource(resource, 0, resource.capacity());
    }

    @JsonIgnore
    public DirectBuffer getResourceBuffer() {
        return this.resourceProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getResourceNameBuffer() {
        return this.resourceNameProp.getValue();
    }

    @Override
    @JsonIgnore
    public int getLength() {
        return super.getLength();
    }

    @Override
    @JsonIgnore
    public int getEncodedLength() {
        return super.getEncodedLength();
    }

    public DeploymentResource setResource(DirectBuffer resource, int offset, int length) {
        this.resourceProp.setValue(resource, offset, length);
        return this;
    }
}

