/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.incident;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class IncidentRecord
extends UnifiedRecordValue
implements IncidentRecordValue {
    private final EnumProperty<ErrorType> errorTypeProp = new EnumProperty<ErrorType>("errorType", ErrorType.class, ErrorType.UNKNOWN);
    private final StringProperty errorMessageProp = new StringProperty("errorMessage", "");
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final LongProperty processDefinitionKeyProp = new LongProperty("processDefinitionKey", -1L);
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey", -1L);
    private final StringProperty elementIdProp = new StringProperty("elementId", "");
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey", -1L);
    private final LongProperty jobKeyProp = new LongProperty("jobKey", -1L);
    private final LongProperty variableScopeKeyProp = new LongProperty("variableScopeKey", -1L);

    public IncidentRecord() {
        this.declareProperty(this.errorTypeProp).declareProperty(this.errorMessageProp).declareProperty(this.bpmnProcessIdProp).declareProperty(this.processDefinitionKeyProp).declareProperty(this.processInstanceKeyProp).declareProperty(this.elementIdProp).declareProperty(this.elementInstanceKeyProp).declareProperty(this.jobKeyProp).declareProperty(this.variableScopeKeyProp);
    }

    public void wrap(IncidentRecord record) {
        this.errorTypeProp.setValue(record.getErrorType());
        this.errorMessageProp.setValue(record.getErrorMessage());
        this.bpmnProcessIdProp.setValue(record.getBpmnProcessIdBuffer());
        this.processDefinitionKeyProp.setValue(record.getProcessDefinitionKey());
        this.processInstanceKeyProp.setValue(record.getProcessInstanceKey());
        this.elementIdProp.setValue(record.getElementIdBuffer());
        this.elementInstanceKeyProp.setValue(record.getElementInstanceKey());
        this.jobKeyProp.setValue(record.getJobKey());
        this.variableScopeKeyProp.setValue(record.getVariableScopeKey());
    }

    public IncidentRecord initFromProcessInstanceFailure(long key, ProcessInstanceRecord processInstanceEvent) {
        this.setElementInstanceKey(key);
        this.setBpmnProcessId(processInstanceEvent.getBpmnProcessIdBuffer());
        this.setProcessDefinitionKey(processInstanceEvent.getProcessDefinitionKey());
        this.setProcessInstanceKey(processInstanceEvent.getProcessInstanceKey());
        this.setElementId(processInstanceEvent.getElementIdBuffer());
        this.setVariableScopeKey(key);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getErrorMessageBuffer() {
        return this.errorMessageProp.getValue();
    }

    @Override
    public ErrorType getErrorType() {
        return this.errorTypeProp.getValue();
    }

    @Override
    public String getErrorMessage() {
        return BufferUtil.bufferAsString(this.errorMessageProp.getValue());
    }

    @Override
    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString(this.bpmnProcessIdProp.getValue());
    }

    public IncidentRecord setBpmnProcessId(DirectBuffer directBuffer) {
        this.bpmnProcessIdProp.setValue(directBuffer, 0, directBuffer.capacity());
        return this;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProp.getValue();
    }

    public IncidentRecord setProcessDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKeyProp.setValue(processDefinitionKey);
        return this;
    }

    @Override
    public String getElementId() {
        return BufferUtil.bufferAsString(this.elementIdProp.getValue());
    }

    public IncidentRecord setElementId(DirectBuffer elementId) {
        this.elementIdProp.setValue(elementId, 0, elementId.capacity());
        return this;
    }

    @Override
    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    public IncidentRecord setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKeyProp.setValue(elementInstanceKey);
        return this;
    }

    @Override
    public long getJobKey() {
        return this.jobKeyProp.getValue();
    }

    @Override
    public long getVariableScopeKey() {
        return this.variableScopeKeyProp.getValue();
    }

    public IncidentRecord setVariableScopeKey(long variableScopeKey) {
        this.variableScopeKeyProp.setValue(variableScopeKey);
        return this;
    }

    public IncidentRecord setJobKey(long jobKey) {
        this.jobKeyProp.setValue(jobKey);
        return this;
    }

    public IncidentRecord setErrorMessage(DirectBuffer errorMessage) {
        this.errorMessageProp.setValue(errorMessage);
        return this;
    }

    public IncidentRecord setErrorMessage(String errorMessage) {
        this.errorMessageProp.setValue(errorMessage);
        return this;
    }

    public IncidentRecord setErrorType(ErrorType errorType) {
        this.errorTypeProp.setValue(errorType);
        return this;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public IncidentRecord setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKeyProp.setValue(processInstanceKey);
        return this;
    }
}

