/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.job;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.PackedProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.spec.MsgPackHelper;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class JobRecord
extends UnifiedRecordValue
implements JobRecordValue {
    public static final DirectBuffer NO_HEADERS = new UnsafeBuffer(MsgPackHelper.EMTPY_OBJECT);
    private static final String EMPTY_STRING = "";
    private static final String RETRIES = "retries";
    private static final String TYPE = "type";
    private static final String CUSTOM_HEADERS = "customHeaders";
    private static final String VARIABLES = "variables";
    private static final String ERROR_MESSAGE = "errorMessage";
    private final StringProperty typeProp = new StringProperty("type", "");
    private final StringProperty workerProp = new StringProperty("worker", "");
    private final LongProperty deadlineProp = new LongProperty("deadline", -1L);
    private final IntegerProperty retriesProp = new IntegerProperty("retries", -1);
    private final LongProperty retryBackoffProp = new LongProperty("retryBackoff", 0L);
    private final LongProperty recurringTimeProp = new LongProperty("recurringTime", -1L);
    private final PackedProperty customHeadersProp = new PackedProperty("customHeaders", NO_HEADERS);
    private final DocumentProperty variableProp = new DocumentProperty("variables");
    private final StringProperty errorMessageProp = new StringProperty("errorMessage", "");
    private final StringProperty errorCodeProp = new StringProperty("errorCode", "");
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey", -1L);
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final IntegerProperty processDefinitionVersionProp = new IntegerProperty("processDefinitionVersion", -1);
    private final LongProperty processDefinitionKeyProp = new LongProperty("processDefinitionKey", -1L);
    private final StringProperty elementIdProp = new StringProperty("elementId", "");
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey", -1L);

    public JobRecord() {
        this.declareProperty(this.deadlineProp).declareProperty(this.workerProp).declareProperty(this.retriesProp).declareProperty(this.retryBackoffProp).declareProperty(this.recurringTimeProp).declareProperty(this.typeProp).declareProperty(this.customHeadersProp).declareProperty(this.variableProp).declareProperty(this.errorMessageProp).declareProperty(this.errorCodeProp).declareProperty(this.bpmnProcessIdProp).declareProperty(this.processDefinitionVersionProp).declareProperty(this.processDefinitionKeyProp).declareProperty(this.processInstanceKeyProp).declareProperty(this.elementIdProp).declareProperty(this.elementInstanceKeyProp);
    }

    public void wrapWithoutVariables(JobRecord record) {
        this.deadlineProp.setValue(record.getDeadline());
        this.workerProp.setValue(record.getWorkerBuffer());
        this.retriesProp.setValue(record.getRetries());
        this.retryBackoffProp.setValue(record.getRetryBackoff());
        this.recurringTimeProp.setValue(record.getRecurringTime());
        this.typeProp.setValue(record.getTypeBuffer());
        DirectBuffer customHeaders = record.getCustomHeadersBuffer();
        this.customHeadersProp.setValue(customHeaders, 0, customHeaders.capacity());
        this.errorMessageProp.setValue(record.getErrorMessageBuffer());
        this.errorCodeProp.setValue(record.getErrorCodeBuffer());
        this.bpmnProcessIdProp.setValue(record.getBpmnProcessIdBuffer());
        this.processDefinitionVersionProp.setValue(record.getProcessDefinitionVersion());
        this.processDefinitionKeyProp.setValue(record.getProcessDefinitionKey());
        this.processInstanceKeyProp.setValue(record.getProcessInstanceKey());
        this.elementIdProp.setValue(record.getElementIdBuffer());
        this.elementInstanceKeyProp.setValue(record.getElementInstanceKey());
    }

    public JobRecord resetVariables() {
        this.variableProp.reset();
        return this;
    }

    @JsonIgnore
    public DirectBuffer getCustomHeadersBuffer() {
        return this.customHeadersProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getErrorMessageBuffer() {
        return this.errorMessageProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getErrorCodeBuffer() {
        return this.errorCodeProp.getValue();
    }

    @Override
    public String getType() {
        return BufferUtil.bufferAsString(this.typeProp.getValue());
    }

    @Override
    public Map<String, String> getCustomHeaders() {
        return MsgPackConverter.convertToStringMap(this.customHeadersProp.getValue());
    }

    @Override
    public String getWorker() {
        return BufferUtil.bufferAsString(this.workerProp.getValue());
    }

    @Override
    public int getRetries() {
        return this.retriesProp.getValue();
    }

    @Override
    public long getRetryBackoff() {
        return this.retryBackoffProp.getValue();
    }

    @Override
    public long getRecurringTime() {
        return this.recurringTimeProp.getValue();
    }

    @Override
    public long getDeadline() {
        return this.deadlineProp.getValue();
    }

    @Override
    public String getErrorMessage() {
        return BufferUtil.bufferAsString(this.errorMessageProp.getValue());
    }

    @Override
    public String getErrorCode() {
        return BufferUtil.bufferAsString(this.errorCodeProp.getValue());
    }

    @Override
    public String getElementId() {
        return BufferUtil.bufferAsString(this.elementIdProp.getValue());
    }

    @Override
    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    @Override
    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString(this.bpmnProcessIdProp.getValue());
    }

    @Override
    public int getProcessDefinitionVersion() {
        return this.processDefinitionVersionProp.getValue();
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProp.getValue();
    }

    public JobRecord setProcessDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKeyProp.setValue(processDefinitionKey);
        return this;
    }

    public JobRecord setProcessDefinitionVersion(int version) {
        this.processDefinitionVersionProp.setValue(version);
        return this;
    }

    public JobRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public JobRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public JobRecord setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKeyProp.setValue(elementInstanceKey);
        return this;
    }

    public JobRecord setElementId(String elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    public JobRecord setElementId(DirectBuffer elementId) {
        return this.setElementId(elementId, 0, elementId.capacity());
    }

    public JobRecord setErrorCode(DirectBuffer errorCode) {
        this.errorCodeProp.setValue(errorCode);
        return this;
    }

    public JobRecord setErrorMessage(String errorMessage) {
        this.errorMessageProp.setValue(errorMessage);
        return this;
    }

    public JobRecord setErrorMessage(DirectBuffer buf) {
        return this.setErrorMessage(buf, 0, buf.capacity());
    }

    public JobRecord setDeadline(long val) {
        this.deadlineProp.setValue(val);
        return this;
    }

    public JobRecord setRecurringTime(long recurringTime) {
        this.recurringTimeProp.setValue(recurringTime);
        return this;
    }

    public JobRecord setRetryBackoff(long retryBackoff) {
        this.retryBackoffProp.setValue(retryBackoff);
        return this;
    }

    public JobRecord setRetries(int retries) {
        this.retriesProp.setValue(retries);
        return this;
    }

    public JobRecord setWorker(String worker) {
        this.workerProp.setValue(worker);
        return this;
    }

    public JobRecord setWorker(DirectBuffer worker) {
        return this.setWorker(worker, 0, worker.capacity());
    }

    public JobRecord setCustomHeaders(DirectBuffer buffer) {
        this.customHeadersProp.setValue(buffer, 0, buffer.capacity());
        return this;
    }

    public JobRecord setType(String type) {
        this.typeProp.setValue(type);
        return this;
    }

    public JobRecord setType(DirectBuffer buf) {
        return this.setType(buf, 0, buf.capacity());
    }

    @JsonIgnore
    public DirectBuffer getTypeBuffer() {
        return this.typeProp.getValue();
    }

    @Override
    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variableProp.getValue());
    }

    public JobRecord setVariables(DirectBuffer variables) {
        this.variableProp.setValue(variables);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variableProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getWorkerBuffer() {
        return this.workerProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public JobRecord setProcessInstanceKey(long key) {
        this.processInstanceKeyProp.setValue(key);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProp.getValue();
    }

    public JobRecord setElementId(DirectBuffer activityId, int offset, int length) {
        this.elementIdProp.setValue(activityId, offset, length);
        return this;
    }

    public JobRecord setErrorMessage(DirectBuffer buf, int offset, int length) {
        this.errorMessageProp.setValue(buf, offset, length);
        return this;
    }

    public JobRecord setType(DirectBuffer buf, int offset, int length) {
        this.typeProp.setValue(buf, offset, length);
        return this;
    }

    public JobRecord setWorker(DirectBuffer worker, int offset, int length) {
        this.workerProp.setValue(worker, offset, length);
        return this;
    }
}

