/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class MessageRecord
extends UnifiedRecordValue
implements MessageRecordValue {
    private final StringProperty nameProp = new StringProperty("name");
    private final StringProperty correlationKeyProp = new StringProperty("correlationKey");
    private final LongProperty timeToLiveProp = new LongProperty("timeToLive");
    private final LongProperty deadlineProp = new LongProperty("deadline", -1L);
    private final DocumentProperty variablesProp = new DocumentProperty("variables");
    private final StringProperty messageIdProp = new StringProperty("messageId", "");

    public MessageRecord() {
        this.declareProperty(this.nameProp).declareProperty(this.correlationKeyProp).declareProperty(this.timeToLiveProp).declareProperty(this.variablesProp).declareProperty(this.messageIdProp).declareProperty(this.deadlineProp);
    }

    public void wrap(MessageRecord record) {
        this.setName(record.getNameBuffer());
        this.setCorrelationKey(record.getCorrelationKeyBuffer());
        this.setTimeToLive(record.getTimeToLive());
        this.setDeadline(record.getDeadline());
        this.setVariables(record.getVariablesBuffer());
        this.setMessageId(record.getMessageIdBuffer());
    }

    public boolean hasMessageId() {
        return this.messageIdProp.getValue().capacity() > 0;
    }

    @JsonIgnore
    public DirectBuffer getCorrelationKeyBuffer() {
        return this.correlationKeyProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getMessageIdBuffer() {
        return this.messageIdProp.getValue();
    }

    @Override
    public String getName() {
        return BufferUtil.bufferAsString(this.nameProp.getValue());
    }

    @Override
    public String getCorrelationKey() {
        return BufferUtil.bufferAsString(this.correlationKeyProp.getValue());
    }

    @Override
    public String getMessageId() {
        return BufferUtil.bufferAsString(this.messageIdProp.getValue());
    }

    @Override
    public long getTimeToLive() {
        return this.timeToLiveProp.getValue();
    }

    public MessageRecord setTimeToLive(long timeToLive) {
        this.timeToLiveProp.setValue(timeToLive);
        return this;
    }

    public MessageRecord setMessageId(String messageId) {
        this.messageIdProp.setValue(messageId);
        return this;
    }

    public MessageRecord setMessageId(DirectBuffer messageId) {
        this.messageIdProp.setValue(messageId);
        return this;
    }

    public MessageRecord setCorrelationKey(String correlationKey) {
        this.correlationKeyProp.setValue(correlationKey);
        return this;
    }

    public MessageRecord setCorrelationKey(DirectBuffer correlationKey) {
        this.correlationKeyProp.setValue(correlationKey);
        return this;
    }

    public MessageRecord setName(String name) {
        this.nameProp.setValue(name);
        return this;
    }

    public MessageRecord setName(DirectBuffer name) {
        this.nameProp.setValue(name);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getNameBuffer() {
        return this.nameProp.getValue();
    }

    @Override
    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProp.getValue());
    }

    public MessageRecord setVariables(DirectBuffer variables) {
        this.variablesProp.setValue(variables);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProp.getValue();
    }

    @Override
    public long getDeadline() {
        return this.deadlineProp.getValue();
    }

    public MessageRecord setDeadline(long deadline) {
        this.deadlineProp.setValue(deadline);
        return this;
    }
}

