/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.processinstance;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessEventRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class ProcessEventRecord
extends UnifiedRecordValue
implements ProcessEventRecordValue {
    private final LongProperty scopeKeyProperty = new LongProperty("scopeKey");
    private final StringProperty targetElementIdProperty = new StringProperty("targetElementId");
    private final DocumentProperty variablesProperty = new DocumentProperty("variables");
    private final LongProperty processDefinitionKeyProperty = new LongProperty("processDefinitionKey", -1L);
    private final LongProperty processInstanceKeyProperty = new LongProperty("processInstanceKey", -1L);

    public ProcessEventRecord() {
        this.declareProperty(this.scopeKeyProperty).declareProperty(this.targetElementIdProperty).declareProperty(this.variablesProperty).declareProperty(this.processDefinitionKeyProperty).declareProperty(this.processInstanceKeyProperty);
    }

    public ProcessEventRecord wrap(ProcessEventRecord record) {
        this.scopeKeyProperty.setValue(record.getScopeKey());
        this.targetElementIdProperty.setValue(record.getTargetElementIdBuffer());
        this.variablesProperty.setValue(record.getVariablesBuffer());
        this.processDefinitionKeyProperty.setValue(record.getProcessDefinitionKey());
        this.processInstanceKeyProperty.setValue(record.getProcessInstanceKey());
        return this;
    }

    @JsonIgnore
    public DirectBuffer getTargetElementIdBuffer() {
        return this.targetElementIdProperty.getValue();
    }

    public ProcessEventRecord setTargetElementIdBuffer(DirectBuffer targetElementIdBuffer) {
        this.targetElementIdProperty.setValue(targetElementIdBuffer);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProperty.getValue();
    }

    public ProcessEventRecord setVariablesBuffer(DirectBuffer variablesBuffer) {
        this.variablesProperty.setValue(variablesBuffer);
        return this;
    }

    @Override
    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.getVariablesBuffer());
    }

    @Override
    public long getScopeKey() {
        return this.scopeKeyProperty.getValue();
    }

    public ProcessEventRecord setScopeKey(long scopeKey) {
        this.scopeKeyProperty.setValue(scopeKey);
        return this;
    }

    @Override
    public String getTargetElementId() {
        return BufferUtil.bufferAsString(this.getTargetElementIdBuffer());
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProperty.getValue();
    }

    public ProcessEventRecord setProcessDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKeyProperty.setValue(processDefinitionKey);
        return this;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKeyProperty.getValue();
    }

    public ProcessEventRecord setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKeyProperty.setValue(processInstanceKey);
        return this;
    }
}

