/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.processinstance;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationStartInstruction;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class ProcessInstanceCreationRecord
extends UnifiedRecordValue
implements ProcessInstanceCreationRecordValue {
    private final StringProperty bpmnProcessIdProperty = new StringProperty("bpmnProcessId", "");
    private final LongProperty processDefinitionKeyProperty = new LongProperty("processDefinitionKey", -1L);
    private final IntegerProperty versionProperty = new IntegerProperty("version", -1);
    private final DocumentProperty variablesProperty = new DocumentProperty("variables");
    private final LongProperty processInstanceKeyProperty = new LongProperty("processInstanceKey", -1L);
    private final ArrayProperty<StringValue> fetchVariablesProperty = new ArrayProperty<StringValue>("fetchVariables", new StringValue());
    private final ArrayProperty<ProcessInstanceCreationStartInstruction> startInstructionsProperty = new ArrayProperty<ProcessInstanceCreationStartInstruction>("startInstructions", new ProcessInstanceCreationStartInstruction());

    public ProcessInstanceCreationRecord() {
        this.declareProperty(this.bpmnProcessIdProperty).declareProperty(this.processDefinitionKeyProperty).declareProperty(this.processInstanceKeyProperty).declareProperty(this.versionProperty).declareProperty(this.variablesProperty).declareProperty(this.fetchVariablesProperty).declareProperty(this.startInstructionsProperty);
    }

    @Override
    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString(this.bpmnProcessIdProperty.getValue());
    }

    @Override
    public int getVersion() {
        return this.versionProperty.getValue();
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProperty.getValue();
    }

    public ProcessInstanceCreationRecord setProcessDefinitionKey(long key) {
        this.processDefinitionKeyProperty.setValue(key);
        return this;
    }

    @Override
    public List<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> getStartInstructions() {
        return this.startInstructionsProperty.stream().map(element -> {
            ProcessInstanceCreationStartInstruction elementCopy = new ProcessInstanceCreationStartInstruction();
            elementCopy.copy((ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue)element);
            return elementCopy;
        }).toList();
    }

    public ProcessInstanceCreationRecord setVersion(int version) {
        this.versionProperty.setValue(version);
        return this;
    }

    public ProcessInstanceCreationRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProperty.setValue(bpmnProcessId);
        return this;
    }

    public ProcessInstanceCreationRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProperty.setValue(bpmnProcessId);
        return this;
    }

    @JsonIgnore
    public boolean hasStartInstructions() {
        return !this.startInstructionsProperty.isEmpty();
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKeyProperty.getValue();
    }

    public ProcessInstanceCreationRecord setProcessInstanceKey(long instanceKey) {
        this.processInstanceKeyProperty.setValue(instanceKey);
        return this;
    }

    @Override
    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProperty.getValue());
    }

    public ProcessInstanceCreationRecord setVariables(DirectBuffer variables) {
        this.variablesProperty.setValue(variables);
        return this;
    }

    public ArrayProperty<StringValue> fetchVariables() {
        return this.fetchVariablesProperty;
    }

    public ProcessInstanceCreationRecord setFetchVariables(List<String> fetchVariables) {
        fetchVariables.forEach(variable -> ((StringValue)this.fetchVariablesProperty.add()).wrap(BufferUtil.wrapString(variable)));
        return this;
    }

    public ArrayProperty<ProcessInstanceCreationStartInstruction> startInstructions() {
        return this.startInstructionsProperty;
    }

    public ProcessInstanceCreationRecord addStartInstructions(List<ProcessInstanceCreationStartInstruction> startInstructions) {
        startInstructions.forEach(this::addStartInstruction);
        return this;
    }

    public ProcessInstanceCreationRecord addStartInstruction(ProcessInstanceCreationStartInstruction startInstruction) {
        ((ProcessInstanceCreationStartInstruction)this.startInstructionsProperty.add()).copy(startInstruction);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProperty.getValue();
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProperty.getValue();
    }
}

