/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.processinstance;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.value.LongValue;
import io.camunda.zeebe.msgpack.value.ObjectValue;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationVariableInstruction;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

@JsonIgnoreProperties(value={"encodedLength"})
public final class ProcessInstanceModificationActivateInstruction
extends ObjectValue
implements ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue {
    private final StringProperty elementIdProperty = new StringProperty("elementId");
    private final LongProperty ancestorScopeKeyProperty = new LongProperty("ancestorScopeKey", -1L);
    private final ArrayProperty<ProcessInstanceModificationVariableInstruction> variableInstructionsProperty = new ArrayProperty<ProcessInstanceModificationVariableInstruction>("variableInstructions", new ProcessInstanceModificationVariableInstruction());
    private final ArrayProperty<LongValue> ancestorScopeKeysProperty = new ArrayProperty<LongValue>("ancestorScopeKeys", new LongValue());

    public ProcessInstanceModificationActivateInstruction() {
        this.declareProperty(this.elementIdProperty).declareProperty(this.ancestorScopeKeyProperty).declareProperty(this.variableInstructionsProperty).declareProperty(this.ancestorScopeKeysProperty);
    }

    @Override
    public String getElementId() {
        return BufferUtil.bufferAsString(this.getElementIdBuffer());
    }

    @Override
    public long getAncestorScopeKey() {
        return this.ancestorScopeKeyProperty.getValue();
    }

    @Override
    public List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> getVariableInstructions() {
        return this.variableInstructionsProperty.stream().map(instruction -> {
            ProcessInstanceModificationVariableInstruction copy = new ProcessInstanceModificationVariableInstruction();
            copy.copy((ProcessInstanceModificationVariableInstruction)instruction);
            return copy;
        }).toList();
    }

    @Override
    public Set<Long> getAncestorScopeKeys() {
        return this.ancestorScopeKeysProperty.stream().map(LongValue::getValue).collect(Collectors.toSet());
    }

    public ProcessInstanceModificationActivateInstruction setAncestorScopeKey(long ancestorScopeKey) {
        this.ancestorScopeKeyProperty.setValue(ancestorScopeKey);
        return this;
    }

    public ProcessInstanceModificationActivateInstruction setElementId(String elementId) {
        this.elementIdProperty.setValue(elementId);
        return this;
    }

    @JsonIgnore
    public boolean hasVariableInstructions() {
        return !this.variableInstructionsProperty.isEmpty();
    }

    public ProcessInstanceModificationActivateInstruction addVariableInstruction(ProcessInstanceModificationVariableInstruction variableInstruction) {
        ((ProcessInstanceModificationVariableInstruction)this.variableInstructionsProperty.add()).copy(variableInstruction);
        return this;
    }

    public ProcessInstanceModificationActivateInstruction addAncestorScopeKeys(Set<Long> flowScopeKeys) {
        flowScopeKeys.forEach(key -> ((LongValue)this.ancestorScopeKeysProperty.add()).setValue((long)key));
        return this;
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProperty.getValue();
    }

    public void copy(ProcessInstanceModificationActivateInstruction object) {
        this.setElementId(object.getElementId());
        this.setAncestorScopeKey(object.getAncestorScopeKey());
        object.getVariableInstructions().stream().map(ProcessInstanceModificationVariableInstruction.class::cast).forEach(this::addVariableInstruction);
        this.addAncestorScopeKeys(object.getAncestorScopeKeys());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

