/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.processinstance;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceResultRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class ProcessInstanceResultRecord
extends UnifiedRecordValue
implements ProcessInstanceResultRecordValue {
    private final StringProperty bpmnProcessIdProperty = new StringProperty("bpmnProcessId", "");
    private final LongProperty processDefinitionKeyProperty = new LongProperty("processDefinitionKey", -1L);
    private final IntegerProperty versionProperty = new IntegerProperty("version", -1);
    private final DocumentProperty variablesProperty = new DocumentProperty("variables");
    private final LongProperty processInstanceKeyProperty = new LongProperty("processInstanceKey", -1L);

    public ProcessInstanceResultRecord() {
        this.declareProperty(this.bpmnProcessIdProperty).declareProperty(this.processDefinitionKeyProperty).declareProperty(this.processInstanceKeyProperty).declareProperty(this.versionProperty).declareProperty(this.variablesProperty);
    }

    @Override
    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString(this.bpmnProcessIdProperty.getValue());
    }

    public ProcessInstanceResultRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProperty.setValue(bpmnProcessId);
        return this;
    }

    public ProcessInstanceResultRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProperty.setValue(bpmnProcessId);
        return this;
    }

    @Override
    public int getVersion() {
        return this.versionProperty.getValue();
    }

    public ProcessInstanceResultRecord setVersion(int version) {
        this.versionProperty.setValue(version);
        return this;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProperty.getValue();
    }

    public ProcessInstanceResultRecord setProcessDefinitionKey(long key) {
        this.processDefinitionKeyProperty.setValue(key);
        return this;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKeyProperty.getValue();
    }

    public ProcessInstanceResultRecord setProcessInstanceKey(long instanceKey) {
        this.processInstanceKeyProperty.setValue(instanceKey);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProperty.getValue();
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProperty.getValue();
    }

    @Override
    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProperty.getValue());
    }

    public ProcessInstanceResultRecord setVariables(DirectBuffer variables) {
        this.variablesProperty.setValue(variables);
        return this;
    }
}

