/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.timer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class TimerRecord
extends UnifiedRecordValue
implements TimerRecordValue {
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey");
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey");
    private final LongProperty dueDateProp = new LongProperty("dueDate");
    private final StringProperty targetElementId = new StringProperty("targetElementId");
    private final IntegerProperty repetitionsProp = new IntegerProperty("repetitions");
    private final LongProperty processDefinitionKeyProp = new LongProperty("processDefinitionKey");

    public TimerRecord() {
        this.declareProperty(this.elementInstanceKeyProp).declareProperty(this.processInstanceKeyProp).declareProperty(this.dueDateProp).declareProperty(this.targetElementId).declareProperty(this.repetitionsProp).declareProperty(this.processDefinitionKeyProp);
    }

    @JsonIgnore
    public DirectBuffer getTargetElementIdBuffer() {
        return this.targetElementId.getValue();
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public TimerRecord setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKeyProp.setValue(processInstanceKey);
        return this;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProp.getValue();
    }

    @Override
    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    @Override
    public long getDueDate() {
        return this.dueDateProp.getValue();
    }

    @Override
    public String getTargetElementId() {
        return BufferUtil.bufferAsString(this.targetElementId.getValue());
    }

    @Override
    public int getRepetitions() {
        return this.repetitionsProp.getValue();
    }

    public TimerRecord setRepetitions(int repetitions) {
        this.repetitionsProp.setValue(repetitions);
        return this;
    }

    public TimerRecord setTargetElementId(DirectBuffer targetElementId) {
        this.targetElementId.setValue(targetElementId);
        return this;
    }

    public TimerRecord setDueDate(long dueDate) {
        this.dueDateProp.setValue(dueDate);
        return this;
    }

    public TimerRecord setElementInstanceKey(long key) {
        this.elementInstanceKeyProp.setValue(key);
        return this;
    }

    public TimerRecord setProcessDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKeyProp.setValue(processDefinitionKey);
        return this;
    }
}

