/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="ProcessInstanceRecordValue", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableProcessInstanceRecordValue
implements ProcessInstanceRecordValue {
    private final String bpmnProcessId;
    private final int version;
    private final long processDefinitionKey;
    private final long processInstanceKey;
    private final String elementId;
    private final long flowScopeKey;
    private final BpmnElementType bpmnElementType;
    private final long parentProcessInstanceKey;
    private final long parentElementInstanceKey;
    private transient int hashCode;

    private ImmutableProcessInstanceRecordValue(String bpmnProcessId, int version, long processDefinitionKey, long processInstanceKey, String elementId, long flowScopeKey, BpmnElementType bpmnElementType, long parentProcessInstanceKey, long parentElementInstanceKey) {
        this.bpmnProcessId = bpmnProcessId;
        this.version = version;
        this.processDefinitionKey = processDefinitionKey;
        this.processInstanceKey = processInstanceKey;
        this.elementId = elementId;
        this.flowScopeKey = flowScopeKey;
        this.bpmnElementType = bpmnElementType;
        this.parentProcessInstanceKey = parentProcessInstanceKey;
        this.parentElementInstanceKey = parentElementInstanceKey;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public long getFlowScopeKey() {
        return this.flowScopeKey;
    }

    @Override
    public BpmnElementType getBpmnElementType() {
        return this.bpmnElementType;
    }

    @Override
    public long getParentProcessInstanceKey() {
        return this.parentProcessInstanceKey;
    }

    @Override
    public long getParentElementInstanceKey() {
        return this.parentElementInstanceKey;
    }

    public final ImmutableProcessInstanceRecordValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(value, this.version, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.flowScopeKey, this.bpmnElementType, this.parentProcessInstanceKey, this.parentElementInstanceKey);
    }

    public final ImmutableProcessInstanceRecordValue withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, value, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.flowScopeKey, this.bpmnElementType, this.parentProcessInstanceKey, this.parentElementInstanceKey);
    }

    public final ImmutableProcessInstanceRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, value, this.processInstanceKey, this.elementId, this.flowScopeKey, this.bpmnElementType, this.parentProcessInstanceKey, this.parentElementInstanceKey);
    }

    public final ImmutableProcessInstanceRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, this.processDefinitionKey, value, this.elementId, this.flowScopeKey, this.bpmnElementType, this.parentProcessInstanceKey, this.parentElementInstanceKey);
    }

    public final ImmutableProcessInstanceRecordValue withElementId(String value) {
        if (Objects.equals(this.elementId, value)) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, value, this.flowScopeKey, this.bpmnElementType, this.parentProcessInstanceKey, this.parentElementInstanceKey);
    }

    public final ImmutableProcessInstanceRecordValue withFlowScopeKey(long value) {
        if (this.flowScopeKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, this.elementId, value, this.bpmnElementType, this.parentProcessInstanceKey, this.parentElementInstanceKey);
    }

    public final ImmutableProcessInstanceRecordValue withBpmnElementType(BpmnElementType value) {
        if (this.bpmnElementType == value) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.flowScopeKey, value, this.parentProcessInstanceKey, this.parentElementInstanceKey);
    }

    public final ImmutableProcessInstanceRecordValue withParentProcessInstanceKey(long value) {
        if (this.parentProcessInstanceKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.flowScopeKey, this.bpmnElementType, value, this.parentElementInstanceKey);
    }

    public final ImmutableProcessInstanceRecordValue withParentElementInstanceKey(long value) {
        if (this.parentElementInstanceKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.flowScopeKey, this.bpmnElementType, this.parentProcessInstanceKey, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessInstanceRecordValue && this.equalTo(0, (ImmutableProcessInstanceRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcessInstanceRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.version == another.version && this.processDefinitionKey == another.processDefinitionKey && this.processInstanceKey == another.processInstanceKey && Objects.equals(this.elementId, another.elementId) && this.flowScopeKey == another.flowScopeKey && Objects.equals((Object)this.bpmnElementType, (Object)another.bpmnElementType) && this.parentProcessInstanceKey == another.parentProcessInstanceKey && this.parentElementInstanceKey == another.parentElementInstanceKey;
    }

    public int hashCode() {
        int h2 = this.hashCode;
        if (h2 == 0) {
            this.hashCode = h2 = this.computeHashCode();
        }
        return h2;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.bpmnProcessId);
        h2 += (h2 << 5) + this.version;
        h2 += (h2 << 5) + Long.hashCode(this.processDefinitionKey);
        h2 += (h2 << 5) + Long.hashCode(this.processInstanceKey);
        h2 += (h2 << 5) + Objects.hashCode(this.elementId);
        h2 += (h2 << 5) + Long.hashCode(this.flowScopeKey);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.bpmnElementType);
        h2 += (h2 << 5) + Long.hashCode(this.parentProcessInstanceKey);
        h2 += (h2 << 5) + Long.hashCode(this.parentElementInstanceKey);
        return h2;
    }

    public String toString() {
        return "ProcessInstanceRecordValue{bpmnProcessId=" + this.bpmnProcessId + ", version=" + this.version + ", processDefinitionKey=" + this.processDefinitionKey + ", processInstanceKey=" + this.processInstanceKey + ", elementId=" + this.elementId + ", flowScopeKey=" + this.flowScopeKey + ", bpmnElementType=" + (Object)((Object)this.bpmnElementType) + ", parentProcessInstanceKey=" + this.parentProcessInstanceKey + ", parentElementInstanceKey=" + this.parentElementInstanceKey + "}";
    }

    public static ImmutableProcessInstanceRecordValue copyOf(ProcessInstanceRecordValue instance) {
        if (instance instanceof ImmutableProcessInstanceRecordValue) {
            return (ImmutableProcessInstanceRecordValue)instance;
        }
        return ImmutableProcessInstanceRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="ProcessInstanceRecordValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String bpmnProcessId;
        private int version;
        private long processDefinitionKey;
        private long processInstanceKey;
        @Nullable
        private String elementId;
        private long flowScopeKey;
        @Nullable
        private BpmnElementType bpmnElementType;
        private long parentProcessInstanceKey;
        private long parentElementInstanceKey;

        private Builder() {
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ProcessInstanceRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ProcessInstanceRelated instance;
            long bits = 0L;
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof ProcessInstanceRecordValue) {
                instance = (ProcessInstanceRecordValue)object;
                String elementIdValue = instance.getElementId();
                if (elementIdValue != null) {
                    this.withElementId(elementIdValue);
                }
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                this.withFlowScopeKey(instance.getFlowScopeKey());
                this.withParentElementInstanceKey(instance.getParentElementInstanceKey());
                String bpmnProcessIdValue = instance.getBpmnProcessId();
                if (bpmnProcessIdValue != null) {
                    this.withBpmnProcessId(bpmnProcessIdValue);
                }
                this.withVersion(instance.getVersion());
                BpmnElementType bpmnElementTypeValue = instance.getBpmnElementType();
                if (bpmnElementTypeValue != null) {
                    this.withBpmnElementType(bpmnElementTypeValue);
                }
                this.withParentProcessInstanceKey(instance.getParentProcessInstanceKey());
                this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
            }
        }

        public final Builder withBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public final Builder withProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder withElementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public final Builder withFlowScopeKey(long flowScopeKey) {
            this.flowScopeKey = flowScopeKey;
            return this;
        }

        public final Builder withBpmnElementType(BpmnElementType bpmnElementType) {
            this.bpmnElementType = bpmnElementType;
            return this;
        }

        public final Builder withParentProcessInstanceKey(long parentProcessInstanceKey) {
            this.parentProcessInstanceKey = parentProcessInstanceKey;
            return this;
        }

        public final Builder withParentElementInstanceKey(long parentElementInstanceKey) {
            this.parentElementInstanceKey = parentElementInstanceKey;
            return this;
        }

        public Builder clear() {
            this.bpmnProcessId = null;
            this.version = 0;
            this.processDefinitionKey = 0L;
            this.processInstanceKey = 0L;
            this.elementId = null;
            this.flowScopeKey = 0L;
            this.bpmnElementType = null;
            this.parentProcessInstanceKey = 0L;
            this.parentElementInstanceKey = 0L;
            return this;
        }

        public ImmutableProcessInstanceRecordValue build() {
            return new ImmutableProcessInstanceRecordValue(this.bpmnProcessId, this.version, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.flowScopeKey, this.bpmnElementType, this.parentProcessInstanceKey, this.parentElementInstanceKey);
        }
    }
}

