/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="DecisionRecordValue", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableDecisionRecordValue
implements DecisionRecordValue {
    private final String decisionId;
    private final String decisionName;
    private final int version;
    private final long decisionKey;
    private final String decisionRequirementsId;
    private final long decisionRequirementsKey;
    private final boolean duplicate;
    private transient int hashCode;

    private ImmutableDecisionRecordValue(String decisionId, String decisionName, int version, long decisionKey, String decisionRequirementsId, long decisionRequirementsKey, boolean duplicate) {
        this.decisionId = decisionId;
        this.decisionName = decisionName;
        this.version = version;
        this.decisionKey = decisionKey;
        this.decisionRequirementsId = decisionRequirementsId;
        this.decisionRequirementsKey = decisionRequirementsKey;
        this.duplicate = duplicate;
    }

    @Override
    public String getDecisionId() {
        return this.decisionId;
    }

    @Override
    public String getDecisionName() {
        return this.decisionName;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getDecisionKey() {
        return this.decisionKey;
    }

    @Override
    public String getDecisionRequirementsId() {
        return this.decisionRequirementsId;
    }

    @Override
    public long getDecisionRequirementsKey() {
        return this.decisionRequirementsKey;
    }

    @Override
    public boolean isDuplicate() {
        return this.duplicate;
    }

    public final ImmutableDecisionRecordValue withDecisionId(String value) {
        if (Objects.equals(this.decisionId, value)) {
            return this;
        }
        return new ImmutableDecisionRecordValue(value, this.decisionName, this.version, this.decisionKey, this.decisionRequirementsId, this.decisionRequirementsKey, this.duplicate);
    }

    public final ImmutableDecisionRecordValue withDecisionName(String value) {
        if (Objects.equals(this.decisionName, value)) {
            return this;
        }
        return new ImmutableDecisionRecordValue(this.decisionId, value, this.version, this.decisionKey, this.decisionRequirementsId, this.decisionRequirementsKey, this.duplicate);
    }

    public final ImmutableDecisionRecordValue withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableDecisionRecordValue(this.decisionId, this.decisionName, value, this.decisionKey, this.decisionRequirementsId, this.decisionRequirementsKey, this.duplicate);
    }

    public final ImmutableDecisionRecordValue withDecisionKey(long value) {
        if (this.decisionKey == value) {
            return this;
        }
        return new ImmutableDecisionRecordValue(this.decisionId, this.decisionName, this.version, value, this.decisionRequirementsId, this.decisionRequirementsKey, this.duplicate);
    }

    public final ImmutableDecisionRecordValue withDecisionRequirementsId(String value) {
        if (Objects.equals(this.decisionRequirementsId, value)) {
            return this;
        }
        return new ImmutableDecisionRecordValue(this.decisionId, this.decisionName, this.version, this.decisionKey, value, this.decisionRequirementsKey, this.duplicate);
    }

    public final ImmutableDecisionRecordValue withDecisionRequirementsKey(long value) {
        if (this.decisionRequirementsKey == value) {
            return this;
        }
        return new ImmutableDecisionRecordValue(this.decisionId, this.decisionName, this.version, this.decisionKey, this.decisionRequirementsId, value, this.duplicate);
    }

    public final ImmutableDecisionRecordValue withDuplicate(boolean value) {
        if (this.duplicate == value) {
            return this;
        }
        return new ImmutableDecisionRecordValue(this.decisionId, this.decisionName, this.version, this.decisionKey, this.decisionRequirementsId, this.decisionRequirementsKey, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDecisionRecordValue && this.equalTo(0, (ImmutableDecisionRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableDecisionRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.decisionId, another.decisionId) && Objects.equals(this.decisionName, another.decisionName) && this.version == another.version && this.decisionKey == another.decisionKey && Objects.equals(this.decisionRequirementsId, another.decisionRequirementsId) && this.decisionRequirementsKey == another.decisionRequirementsKey && this.duplicate == another.duplicate;
    }

    public int hashCode() {
        int h2 = this.hashCode;
        if (h2 == 0) {
            this.hashCode = h2 = this.computeHashCode();
        }
        return h2;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.decisionId);
        h2 += (h2 << 5) + Objects.hashCode(this.decisionName);
        h2 += (h2 << 5) + this.version;
        h2 += (h2 << 5) + Long.hashCode(this.decisionKey);
        h2 += (h2 << 5) + Objects.hashCode(this.decisionRequirementsId);
        h2 += (h2 << 5) + Long.hashCode(this.decisionRequirementsKey);
        h2 += (h2 << 5) + Boolean.hashCode(this.duplicate);
        return h2;
    }

    public String toString() {
        return "DecisionRecordValue{decisionId=" + this.decisionId + ", decisionName=" + this.decisionName + ", version=" + this.version + ", decisionKey=" + this.decisionKey + ", decisionRequirementsId=" + this.decisionRequirementsId + ", decisionRequirementsKey=" + this.decisionRequirementsKey + ", duplicate=" + this.duplicate + "}";
    }

    public static ImmutableDecisionRecordValue copyOf(DecisionRecordValue instance) {
        if (instance instanceof ImmutableDecisionRecordValue) {
            return (ImmutableDecisionRecordValue)instance;
        }
        return ImmutableDecisionRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="DecisionRecordValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String decisionId;
        @Nullable
        private String decisionName;
        private int version;
        private long decisionKey;
        @Nullable
        private String decisionRequirementsId;
        private long decisionRequirementsKey;
        private boolean duplicate;

        private Builder() {
        }

        public final Builder from(DecisionRecordValue instance) {
            String decisionNameValue;
            Objects.requireNonNull(instance, "instance");
            String decisionIdValue = instance.getDecisionId();
            if (decisionIdValue != null) {
                this.withDecisionId(decisionIdValue);
            }
            if ((decisionNameValue = instance.getDecisionName()) != null) {
                this.withDecisionName(decisionNameValue);
            }
            this.withVersion(instance.getVersion());
            this.withDecisionKey(instance.getDecisionKey());
            String decisionRequirementsIdValue = instance.getDecisionRequirementsId();
            if (decisionRequirementsIdValue != null) {
                this.withDecisionRequirementsId(decisionRequirementsIdValue);
            }
            this.withDecisionRequirementsKey(instance.getDecisionRequirementsKey());
            this.withDuplicate(instance.isDuplicate());
            return this;
        }

        public final Builder withDecisionId(String decisionId) {
            this.decisionId = decisionId;
            return this;
        }

        public final Builder withDecisionName(String decisionName) {
            this.decisionName = decisionName;
            return this;
        }

        public final Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public final Builder withDecisionKey(long decisionKey) {
            this.decisionKey = decisionKey;
            return this;
        }

        public final Builder withDecisionRequirementsId(String decisionRequirementsId) {
            this.decisionRequirementsId = decisionRequirementsId;
            return this;
        }

        public final Builder withDecisionRequirementsKey(long decisionRequirementsKey) {
            this.decisionRequirementsKey = decisionRequirementsKey;
            return this;
        }

        public final Builder withDuplicate(boolean duplicate) {
            this.duplicate = duplicate;
            return this;
        }

        public Builder clear() {
            this.decisionId = null;
            this.decisionName = null;
            this.version = 0;
            this.decisionKey = 0L;
            this.decisionRequirementsId = null;
            this.decisionRequirementsKey = 0L;
            this.duplicate = false;
            return this;
        }

        public ImmutableDecisionRecordValue build() {
            return new ImmutableDecisionRecordValue(this.decisionId, this.decisionName, this.version, this.decisionKey, this.decisionRequirementsId, this.decisionRequirementsKey, this.duplicate);
        }
    }
}

