/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="ProcessMetadataValue", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableProcessMetadataValue
implements ProcessMetadataValue {
    private final String bpmnProcessId;
    private final int version;
    private final long processDefinitionKey;
    private final String resourceName;
    private final byte[] checksum;
    private final boolean duplicate;
    private transient int hashCode;

    private ImmutableProcessMetadataValue(String bpmnProcessId, int version, long processDefinitionKey, String resourceName, byte[] checksum, boolean duplicate) {
        this.bpmnProcessId = bpmnProcessId;
        this.version = version;
        this.processDefinitionKey = processDefinitionKey;
        this.resourceName = resourceName;
        this.checksum = checksum;
        this.duplicate = duplicate;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public byte[] getChecksum() {
        return this.checksum;
    }

    @Override
    public boolean isDuplicate() {
        return this.duplicate;
    }

    public final ImmutableProcessMetadataValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableProcessMetadataValue(value, this.version, this.processDefinitionKey, this.resourceName, this.checksum, this.duplicate);
    }

    public final ImmutableProcessMetadataValue withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableProcessMetadataValue(this.bpmnProcessId, value, this.processDefinitionKey, this.resourceName, this.checksum, this.duplicate);
    }

    public final ImmutableProcessMetadataValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableProcessMetadataValue(this.bpmnProcessId, this.version, value, this.resourceName, this.checksum, this.duplicate);
    }

    public final ImmutableProcessMetadataValue withResourceName(String value) {
        if (Objects.equals(this.resourceName, value)) {
            return this;
        }
        return new ImmutableProcessMetadataValue(this.bpmnProcessId, this.version, this.processDefinitionKey, value, this.checksum, this.duplicate);
    }

    public final ImmutableProcessMetadataValue withChecksum(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableProcessMetadataValue(this.bpmnProcessId, this.version, this.processDefinitionKey, this.resourceName, newValue, this.duplicate);
    }

    public final ImmutableProcessMetadataValue withDuplicate(boolean value) {
        if (this.duplicate == value) {
            return this;
        }
        return new ImmutableProcessMetadataValue(this.bpmnProcessId, this.version, this.processDefinitionKey, this.resourceName, this.checksum, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessMetadataValue && this.equalTo(0, (ImmutableProcessMetadataValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcessMetadataValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.version == another.version && this.processDefinitionKey == another.processDefinitionKey && Objects.equals(this.resourceName, another.resourceName) && Arrays.equals(this.checksum, another.checksum) && this.duplicate == another.duplicate;
    }

    public int hashCode() {
        int h2 = this.hashCode;
        if (h2 == 0) {
            this.hashCode = h2 = this.computeHashCode();
        }
        return h2;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.bpmnProcessId);
        h2 += (h2 << 5) + this.version;
        h2 += (h2 << 5) + Long.hashCode(this.processDefinitionKey);
        h2 += (h2 << 5) + Objects.hashCode(this.resourceName);
        h2 += (h2 << 5) + Arrays.hashCode(this.checksum);
        h2 += (h2 << 5) + Boolean.hashCode(this.duplicate);
        return h2;
    }

    public String toString() {
        return "ProcessMetadataValue{bpmnProcessId=" + this.bpmnProcessId + ", version=" + this.version + ", processDefinitionKey=" + this.processDefinitionKey + ", resourceName=" + this.resourceName + ", checksum=" + Arrays.toString(this.checksum) + ", duplicate=" + this.duplicate + "}";
    }

    public static ImmutableProcessMetadataValue copyOf(ProcessMetadataValue instance) {
        if (instance instanceof ImmutableProcessMetadataValue) {
            return (ImmutableProcessMetadataValue)instance;
        }
        return ImmutableProcessMetadataValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="ProcessMetadataValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String bpmnProcessId;
        private int version;
        private long processDefinitionKey;
        @Nullable
        private String resourceName;
        @Nullable
        private byte[] checksum;
        private boolean duplicate;

        private Builder() {
        }

        public final Builder from(ProcessMetadataValue instance) {
            byte[] checksumValue;
            Objects.requireNonNull(instance, "instance");
            String bpmnProcessIdValue = instance.getBpmnProcessId();
            if (bpmnProcessIdValue != null) {
                this.withBpmnProcessId(bpmnProcessIdValue);
            }
            this.withVersion(instance.getVersion());
            this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
            String resourceNameValue = instance.getResourceName();
            if (resourceNameValue != null) {
                this.withResourceName(resourceNameValue);
            }
            if ((checksumValue = instance.getChecksum()) != null) {
                this.withChecksum(checksumValue);
            }
            this.withDuplicate(instance.isDuplicate());
            return this;
        }

        public final Builder withBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public final Builder withProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final Builder withChecksum(byte ... checksum) {
            this.checksum = checksum;
            return this;
        }

        public final Builder withDuplicate(boolean duplicate) {
            this.duplicate = duplicate;
            return this;
        }

        public Builder clear() {
            this.bpmnProcessId = null;
            this.version = 0;
            this.processDefinitionKey = 0L;
            this.resourceName = null;
            this.checksum = null;
            this.duplicate = false;
            return this;
        }

        public ImmutableProcessMetadataValue build() {
            return new ImmutableProcessMetadataValue(this.bpmnProcessId, this.version, this.processDefinitionKey, this.resourceName, this.checksum, this.duplicate);
        }
    }
}

