/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.scheduler.TimerSubscription;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.util.Loggers;
import java.util.concurrent.TimeUnit;
import org.agrona.DeadlineTimerWheel;
import org.agrona.collections.Long2ObjectHashMap;
import org.slf4j.Logger;

public final class ActorTimerQueue
extends DeadlineTimerWheel {
    private static final Logger LOG = Loggers.ACTOR_LOGGER;
    private static final int DEFAULT_TICKS_PER_WHEEL = 32;
    private final Long2ObjectHashMap<TimerSubscription> timerJobMap = new Long2ObjectHashMap();
    private final DeadlineTimerWheel.TimerHandler timerHandler = (timeUnit, now, timerId) -> {
        TimerSubscription timer = this.timerJobMap.remove(timerId);
        if (timer != null) {
            timer.onTimerExpired(timeUnit, now);
        } else {
            LOG.warn("Timer with id {} expired but is not known in this timer queue.", (Object)timerId);
        }
        return true;
    };

    public ActorTimerQueue(ActorClock clock) {
        this(clock, 32);
    }

    public ActorTimerQueue(ActorClock clock, int ticksPerWheel) {
        super(TimeUnit.MILLISECONDS, clock.getTimeMillis(), 1L, ticksPerWheel);
    }

    public void processExpiredTimers(ActorClock clock) {
        int timersProcessed = 0;
        while ((timersProcessed = this.poll(clock.getTimeMillis(), this.timerHandler, Integer.MAX_VALUE)) > 0) {
        }
    }

    public void schedule(TimerSubscription timer, ActorClock now) {
        long deadline = now.getTimeMillis() + this.timeUnit().convert(timer.getDeadline(), timer.getTimeUnit());
        long timerId = this.scheduleTimer(deadline);
        timer.setTimerId(timerId);
        if (this.timerJobMap.containsKey(timerId)) {
            throw new IllegalStateException("Failed scheduling, timer with id " + timerId + " already exists: " + this.timerJobMap.get(timerId));
        }
        this.timerJobMap.put(timerId, timer);
    }

    public void remove(TimerSubscription timer) {
        long timerId = timer.getTimerId();
        this.timerJobMap.remove(timerId);
        this.cancelTimer(timerId);
    }
}

