/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.future;

import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class ActorFutureCollector<V>
implements Collector<ActorFuture<V>, List<ActorFuture<V>>, ActorFuture<List<V>>> {
    private final ConcurrencyControl concurrencyControl;

    public ActorFutureCollector(ConcurrencyControl concurrencyControl) {
        this.concurrencyControl = Objects.requireNonNull(concurrencyControl);
    }

    @Override
    public Supplier<List<ActorFuture<V>>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<List<ActorFuture<V>>, ActorFuture<V>> accumulator() {
        return List::add;
    }

    @Override
    public BinaryOperator<List<ActorFuture<V>>> combiner() {
        return (listA, listB) -> {
            listA.addAll(listB);
            return listA;
        };
    }

    @Override
    public Function<List<ActorFuture<V>>, ActorFuture<List<V>>> finisher() {
        return futures -> new CompletionWaiter(this.concurrencyControl, futures).get();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    private static final class CompletionWaiter<V>
    implements Supplier<ActorFuture<List<V>>> {
        private final ConcurrencyControl concurrencyControl;
        private final List<ActorFuture<V>> pendingFutures;
        private final Either<Throwable, V>[] results;
        private ActorFuture<List<V>> aggregated;

        private CompletionWaiter(ConcurrencyControl concurrencyControl, List<ActorFuture<V>> pendingFutures) {
            this.concurrencyControl = concurrencyControl;
            this.pendingFutures = new ArrayList<ActorFuture<V>>(pendingFutures);
            this.results = new Either[pendingFutures.size()];
        }

        @Override
        public ActorFuture<List<V>> get() {
            this.aggregated = this.concurrencyControl.createFuture();
            if (this.pendingFutures.isEmpty()) {
                this.aggregated.complete(Collections.emptyList());
            } else {
                int index = 0;
                while (index < this.pendingFutures.size()) {
                    ActorFuture<V> pendingFuture = this.pendingFutures.get(index);
                    int currentIndex = index++;
                    this.concurrencyControl.runOnCompletion(pendingFuture, (result, error2) -> this.handleCompletion(pendingFuture, currentIndex, (V)result, (Throwable)error2));
                }
            }
            return this.aggregated;
        }

        private void handleCompletion(ActorFuture<V> pendingFuture, int currentIndex, V result, Throwable error2) {
            this.pendingFutures.remove(pendingFuture);
            Either<Object, Object> either = this.results[currentIndex] = error2 == null ? Either.right(result) : Either.left(error2);
            if (this.pendingFutures.isEmpty()) {
                this.completeAggregatedFuture();
            }
        }

        private void completeAggregatedFuture() {
            Either aggregatedResult = Arrays.stream(this.results).collect(Either.collector());
            if (aggregatedResult.isRight()) {
                this.aggregated.complete(aggregatedResult.get());
            } else {
                Exception exception = new Exception("Errors occurred, see suppressed exceptions for details");
                aggregatedResult.getLeft().forEach(exception::addSuppressed);
                this.aggregated.completeExceptionally(exception);
            }
        }
    }
}

