/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.engine.api.TaskResult;
import io.camunda.zeebe.engine.api.TaskResultBuilder;
import io.camunda.zeebe.engine.api.records.MutableRecordBatch;
import io.camunda.zeebe.engine.api.records.RecordBatch;
import io.camunda.zeebe.engine.api.records.RecordBatchSizePredicate;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedEventRegistry;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.Either;

final class BufferedTaskResultBuilder
implements TaskResultBuilder {
    private final MutableRecordBatch mutableRecordBatch;

    BufferedTaskResultBuilder(RecordBatchSizePredicate predicate) {
        this.mutableRecordBatch = new RecordBatch(predicate);
    }

    @Override
    public boolean appendCommandRecord(long key, Intent intent, UnifiedRecordValue value) {
        ValueType valueType = TypedEventRegistry.TYPE_REGISTRY.get(value.getClass());
        if (valueType == null) {
            throw new IllegalStateException("Missing value type mapping for record: " + value.getClass());
        }
        Either<RuntimeException, Void> either = this.mutableRecordBatch.appendRecord(key, -1, RecordType.COMMAND, intent, RejectionType.NULL_VAL, "", valueType, value);
        return either.isRight();
    }

    @Override
    public TaskResult build() {
        return () -> this.mutableRecordBatch;
    }
}

