/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.api.InterPartitionCommandSender;
import io.camunda.zeebe.engine.api.ProcessingScheduleService;
import io.camunda.zeebe.engine.api.RecordProcessorContext;
import io.camunda.zeebe.engine.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.KeyGeneratorControls;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public final class RecordProcessorContextImpl
implements RecordProcessorContext {
    private final int partitionId;
    private final ProcessingScheduleService scheduleService;
    private final ZeebeDb zeebeDb;
    private final TransactionContext transactionContext;
    private final Function<MutableProcessingState, EventApplier> eventApplierFactory;
    private final List<StreamProcessorLifecycleAware> lifecycleListeners = new ArrayList<StreamProcessorLifecycleAware>();
    private final InterPartitionCommandSender partitionCommandSender;
    private final KeyGenerator keyGenerator;

    public RecordProcessorContextImpl(int partitionId, ProcessingScheduleService scheduleService, ZeebeDb zeebeDb, TransactionContext transactionContext, Function<MutableProcessingState, EventApplier> eventApplierFactory, InterPartitionCommandSender partitionCommandSender, KeyGeneratorControls keyGeneratorControls) {
        this.partitionId = partitionId;
        this.scheduleService = scheduleService;
        this.zeebeDb = zeebeDb;
        this.transactionContext = transactionContext;
        this.eventApplierFactory = eventApplierFactory;
        this.partitionCommandSender = partitionCommandSender;
        this.keyGenerator = keyGeneratorControls;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public ProcessingScheduleService getScheduleService() {
        return this.scheduleService;
    }

    @Override
    public ZeebeDb getZeebeDb() {
        return this.zeebeDb;
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public Function<MutableProcessingState, EventApplier> getEventApplierFactory() {
        return this.eventApplierFactory;
    }

    @Override
    public List<StreamProcessorLifecycleAware> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    @Override
    public void addLifecycleListeners(List<StreamProcessorLifecycleAware> lifecycleListeners) {
        this.lifecycleListeners.addAll(lifecycleListeners);
    }

    @Override
    public InterPartitionCommandSender getPartitionCommandSender() {
        return this.partitionCommandSender;
    }

    @Override
    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }
}

