/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;

public class UnwrittenRecord
implements TypedRecord {
    private final long key;
    private final int partitionId;
    private final UnifiedRecordValue value;
    private final RecordMetadata metadata;

    public UnwrittenRecord(long key, int partitionId, UnifiedRecordValue value, RecordMetadata metadata) {
        this.key = key;
        this.partitionId = partitionId;
        this.value = value;
        this.metadata = metadata;
    }

    @Override
    public long getPosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSourceRecordPosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTimestamp() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Intent getIntent() {
        return this.metadata.getIntent();
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public RecordType getRecordType() {
        return this.metadata.getRecordType();
    }

    @Override
    public RejectionType getRejectionType() {
        return this.metadata.getRejectionType();
    }

    @Override
    public String getRejectionReason() {
        return this.metadata.getRejectionReason();
    }

    @Override
    public String getBrokerVersion() {
        return this.metadata.getBrokerVersion().toString();
    }

    @Override
    public ValueType getValueType() {
        return this.metadata.getValueType();
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public UnifiedRecordValue getValue() {
        return this.value;
    }

    @Override
    public int getRequestStreamId() {
        return this.metadata.getRequestStreamId();
    }

    @Override
    public long getRequestId() {
        return this.metadata.getRequestId();
    }

    @Override
    public int getLength() {
        return this.metadata.getLength() + this.value.getLength();
    }
}

