/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import io.camunda.zeebe.util.CheckedRunnable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.MDC;

public final class LogUtil {
    private LogUtil() {
    }

    public static void doWithMDC(Map<String, String> context, Runnable r) {
        Map<String, String> currentContext = MDC.getCopyOfContextMap();
        MDC.setContextMap(context);
        try {
            r.run();
        }
        finally {
            if (currentContext != null) {
                MDC.setContextMap(currentContext);
            } else {
                MDC.clear();
            }
        }
    }

    public static void catchAndLog(Logger log, CheckedRunnable r) {
        try {
            r.run();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }
}

