/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.stream.LongStream;

public class LongArrayList
extends AbstractList<Long>
implements List<Long>,
RandomAccess {
    public static final long DEFAULT_NULL_VALUE = Long.MIN_VALUE;
    public static final int INITIAL_CAPACITY = 10;
    private final long nullValue;
    private int size = 0;
    private long[] elements;

    public LongArrayList() {
        this(10, Long.MIN_VALUE);
    }

    public LongArrayList(int initialCapacity, long nullValue) {
        this.nullValue = nullValue;
        this.elements = new long[Math.max(initialCapacity, 10)];
    }

    public LongArrayList(long[] initialElements, int initialSize, long nullValue) {
        this.wrap(initialElements, initialSize);
        this.nullValue = nullValue;
    }

    public void wrap(long[] initialElements, int initialSize) {
        if (initialSize < 0 || initialSize > initialElements.length) {
            throw new IllegalArgumentException("illegal initial size " + initialSize + " for array length of " + initialElements.length);
        }
        this.elements = initialElements;
        this.size = initialSize;
    }

    public long nullValue() {
        return this.nullValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.elements.length;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trimToSize() {
        if (this.elements.length != this.size && this.elements.length > 10) {
            this.elements = Arrays.copyOf(this.elements, Math.max(10, this.size));
        }
    }

    @Override
    public Long get(int index) {
        long value = this.getLong(index);
        return this.nullValue == value ? null : Long.valueOf(value);
    }

    public long getLong(int index) {
        this.checkIndex(index);
        return this.elements[index];
    }

    @Override
    public boolean add(Long element) {
        return this.addLong(null == element ? this.nullValue : element);
    }

    public boolean addLong(long element) {
        this.ensureCapacityPrivate(this.size + 1);
        this.elements[this.size] = element;
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, Long element) {
        this.addLong(index, null == element ? this.nullValue : element);
    }

    public void addLong(int index, long element) {
        this.checkIndexForAdd(index);
        int requiredSize = this.size + 1;
        this.ensureCapacityPrivate(requiredSize);
        if (index < this.size) {
            System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        }
        this.elements[index] = element;
        ++this.size;
    }

    @Override
    public Long set(int index, Long element) {
        long previous = this.setLong(index, null == element ? this.nullValue : element);
        return this.nullValue == previous ? null : Long.valueOf(previous);
    }

    public long setLong(int index, long element) {
        this.checkIndex(index);
        long previous = this.elements[index];
        this.elements[index] = element;
        return previous;
    }

    @Override
    public boolean contains(Object o) {
        return this.containsLong(null == o ? this.nullValue : (Long)o);
    }

    public boolean containsLong(long value) {
        return -1 != this.indexOf(value);
    }

    public int indexOf(long value) {
        long[] elements = this.elements;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            if (value != elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long value) {
        long[] elements = this.elements;
        for (int i = this.size - 1; i >= 0; --i) {
            if (value != elements[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean addAll(LongArrayList list) {
        int numElements = list.size;
        if (numElements > 0) {
            this.ensureCapacityPrivate(this.size + numElements);
            System.arraycopy(list.elements, 0, this.elements, this.size, numElements);
            this.size += numElements;
            return true;
        }
        return false;
    }

    public boolean addAll(int index, LongArrayList list) {
        this.checkIndexForAdd(index);
        int numElements = list.size;
        if (numElements > 0) {
            int size = this.size;
            this.ensureCapacityPrivate(size + numElements);
            long[] elements = this.elements;
            for (int i = size - 1; i >= index; --i) {
                elements[i + numElements] = elements[i];
            }
            System.arraycopy(list.elements, 0, elements, index, numElements);
            this.size += numElements;
            return true;
        }
        return false;
    }

    public boolean containsAll(LongArrayList list) {
        long[] listElements = list.elements;
        long listNullValue = list.nullValue;
        boolean hasNulls = this.contains(null);
        int size = list.size;
        for (int i = 0; i < size; ++i) {
            long value = listElements[i];
            if (this.containsLong(value) || hasNulls && listNullValue == value) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(LongArrayList list) {
        long[] elements = this.elements;
        int size = this.size;
        if (size > 0) {
            if (list.isEmpty()) {
                this.size = 0;
                return true;
            }
            long nullValue = this.nullValue;
            boolean listHasNulls = list.contains(null);
            long[] filteredElements = null;
            int j = -1;
            for (int i = 0; i < size; ++i) {
                long value = elements[i];
                if (!(list.containsLong(value) || listHasNulls && nullValue == value)) {
                    if (null != filteredElements) continue;
                    filteredElements = Arrays.copyOf(elements, size);
                    j = i - 1;
                    continue;
                }
                if (null == filteredElements) continue;
                filteredElements[++j] = value;
            }
            if (null != filteredElements) {
                this.elements = filteredElements;
                this.size = j + 1;
                return true;
            }
        }
        return false;
    }

    public boolean removeAll(LongArrayList list) {
        long[] elements = this.elements;
        int size = this.size;
        if (size > 0 && !list.isEmpty()) {
            long nullValue = this.nullValue;
            boolean listHasNulls = list.contains(null);
            long[] filteredElements = null;
            int j = -1;
            for (int i = 0; i < size; ++i) {
                long value = elements[i];
                if (list.containsLong(value) || listHasNulls && nullValue == value) {
                    if (null != filteredElements) continue;
                    filteredElements = Arrays.copyOf(elements, size);
                    j = i - 1;
                    continue;
                }
                if (null == filteredElements) continue;
                filteredElements[++j] = value;
            }
            if (null != filteredElements) {
                this.elements = filteredElements;
                this.size = j + 1;
                return true;
            }
        }
        return false;
    }

    public boolean removeIfLong(LongPredicate filter) {
        Objects.requireNonNull(filter);
        long[] elements = this.elements;
        int size = this.size;
        if (size > 0) {
            long[] filteredElements = null;
            int j = -1;
            for (int i = 0; i < size; ++i) {
                long value = elements[i];
                if (filter.test(value)) {
                    if (null != filteredElements) continue;
                    filteredElements = Arrays.copyOf(elements, size);
                    j = i - 1;
                    continue;
                }
                if (null == filteredElements) continue;
                filteredElements[++j] = value;
            }
            if (null != filteredElements) {
                this.elements = filteredElements;
                this.size = j + 1;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeLong(null == o ? this.nullValue : (Long)o);
    }

    @Override
    public Long remove(int index) {
        long value = this.removeAt(index);
        return this.nullValue == value ? null : Long.valueOf(value);
    }

    public long removeAt(int index) {
        this.checkIndex(index);
        long value = this.elements[index];
        int moveCount = this.size - index - 1;
        if (moveCount > 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, moveCount);
        }
        --this.size;
        return value;
    }

    public long fastUnorderedRemove(int index) {
        this.checkIndex(index);
        long value = this.elements[index];
        this.elements[index] = this.elements[--this.size];
        return value;
    }

    public boolean removeLong(long value) {
        int index = this.indexOf(value);
        if (-1 != index) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean fastUnorderedRemoveLong(long value) {
        int index = this.indexOf(value);
        if (-1 != index) {
            this.elements[index] = this.elements[--this.size];
            return true;
        }
        return false;
    }

    public void pushLong(long element) {
        this.ensureCapacityPrivate(this.size + 1);
        this.elements[this.size] = element;
        ++this.size;
    }

    public long popLong() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements[--this.size];
    }

    public void forEachOrderedLong(LongConsumer action) {
        long[] elements = this.elements;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            action.accept(elements[i]);
        }
    }

    public LongStream longStream() {
        return Arrays.stream(this.elements, 0, this.size);
    }

    public long[] toLongArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    public long[] toLongArray(long[] dst) {
        if (dst.length == this.size) {
            System.arraycopy(this.elements, 0, dst, 0, dst.length);
            return dst;
        }
        return Arrays.copyOf(this.elements, this.size);
    }

    public void ensureCapacity(int requiredCapacity) {
        this.ensureCapacityPrivate(Math.max(requiredCapacity, 10));
    }

    public boolean equals(LongArrayList that) {
        if (that == this) {
            return true;
        }
        boolean isEqual = false;
        long size = this.size;
        if (size == (long)that.size) {
            isEqual = true;
            long[] elements = this.elements;
            long[] thatElements = that.elements;
            int i = 0;
            while ((long)i < size) {
                long thisValue = elements[i];
                long thatValue = thatElements[i];
                if (thisValue != thatValue && (thisValue != this.nullValue || thatValue != that.nullValue)) {
                    isEqual = false;
                    break;
                }
                ++i;
            }
        }
        return isEqual;
    }

    @Override
    public boolean equals(Object other) {
        List that;
        if (other == this) {
            return true;
        }
        boolean isEqual = false;
        if (other instanceof LongArrayList) {
            return this.equals((LongArrayList)other);
        }
        if (other instanceof List && this.size == (that = (List)other).size()) {
            isEqual = true;
            int i = 0;
            for (Object o : that) {
                Long thatValue;
                Long thisValue;
                if ((null == o || o instanceof Long) && Objects.equals(thisValue = this.get(i++), thatValue = (Long)o)) continue;
                isEqual = false;
                break;
            }
        }
        return isEqual;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        long nullValue = this.nullValue;
        long[] elements = this.elements;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            long value = elements[i];
            hashCode = 31 * hashCode + (nullValue == value ? 0 : Long.hashCode(value));
        }
        return hashCode;
    }

    @Override
    public void forEach(Consumer<? super Long> action) {
        Objects.requireNonNull(action);
        long nullValue = this.nullValue;
        long[] elements = this.elements;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            long value = elements[i];
            action.accept(nullValue != value ? Long.valueOf(value) : null);
        }
    }

    public void forEachLong(LongConsumer action) {
        Objects.requireNonNull(action);
        long[] elements = this.elements;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            action.accept(elements[i]);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        long nullValue = this.nullValue;
        long[] elements = this.elements;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            long value = elements[i];
            sb.append(value != nullValue ? Long.valueOf(value) : null).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }

    private void ensureCapacityPrivate(int requiredCapacity) {
        int currentCapacity = this.elements.length;
        if (requiredCapacity > currentCapacity) {
            int newCapacity;
            if (requiredCapacity > 0x7FFFFFF7) {
                throw new IllegalStateException("max capacity: 2147483639");
            }
            int n = newCapacity = currentCapacity > 10 ? currentCapacity : 10;
            while (newCapacity < requiredCapacity) {
                if ((newCapacity += newCapacity >> 1) >= 0 && newCapacity < 0x7FFFFFF7) continue;
                newCapacity = 0x7FFFFFF7;
            }
            long[] newElements = new long[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, currentCapacity);
            this.elements = newElements;
        }
    }

    private void checkIndex(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
    }

    private void checkIndexForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
    }
}

